/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.search.simplified;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.EpisodeSimplified;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class SearchEpisodesRequest
extends AbstractDataRequest<Paging<EpisodeSimplified>> {
    private SearchEpisodesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<EpisodeSimplified> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new EpisodeSimplified.JsonUtil().createModelObjectPaging(this.getJson(), "episodes");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<EpisodeSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder q(String q) {
            assert (q != null);
            assert (!q.isEmpty());
            return (Builder)this.setQueryParameter("q", q);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset != null);
            assert (0 <= offset && offset <= 100000);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder includeExternal(String includeExternal) {
            assert (includeExternal != null);
            assert (includeExternal.matches("audio"));
            return (Builder)this.setQueryParameter("include_external", includeExternal);
        }

        public SearchEpisodesRequest build() {
            this.setPath("/v1/search");
            this.setQueryParameter("type", "episode");
            return new SearchEpisodesRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

