/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.miscellaneous;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.util.Objects;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;

@JsonDeserialize(builder=Builder.class)
public class Device
extends AbstractModelObject {
    private final String id;
    private final Boolean is_active;
    private final Boolean is_private_session;
    private final Boolean is_restricted;
    private final String name;
    private final Boolean supports_volume;
    private final String type;
    private final Integer volume_percent;

    private Device(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.is_active = builder.is_active;
        this.is_private_session = builder.is_private_session;
        this.is_restricted = builder.is_restricted;
        this.name = builder.name;
        this.supports_volume = builder.supports_volume;
        this.type = builder.type;
        this.volume_percent = builder.volume_percent;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getIs_active() {
        return this.is_active;
    }

    public Boolean getIs_private_session() {
        return this.is_private_session;
    }

    public Boolean getIs_restricted() {
        return this.is_restricted;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getSupports_volume() {
        return this.supports_volume;
    }

    public String getType() {
        return this.type;
    }

    public Integer getVolume_percent() {
        return this.volume_percent;
    }

    @Override
    public String toString() {
        return "Device(id=" + this.id + ", is_active=" + this.is_active + ", is_private_session=" + this.is_private_session + ", is_restricted=" + this.is_restricted + ", name=" + this.name + ", supports_volume=" + this.supports_volume + ", type=" + this.type + ", volume_percent=" + this.volume_percent + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.id, device.id) && Objects.equals(this.name, device.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Device> {
        @Override
        public Device createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setIs_active(this.hasAndNotNull(jsonObject, "is_active") ? Boolean.valueOf(jsonObject.get("is_active").getAsBoolean()) : null).setIs_private_session(this.hasAndNotNull(jsonObject, "is_private_session") ? Boolean.valueOf(jsonObject.get("is_private_session").getAsBoolean()) : null).setIs_restricted(this.hasAndNotNull(jsonObject, "is_restricted") ? Boolean.valueOf(jsonObject.get("is_restricted").getAsBoolean()) : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).setSupports_volume(this.hasAndNotNull(jsonObject, "supports_volume") ? Boolean.valueOf(jsonObject.get("supports_volume").getAsBoolean()) : null).setType(this.hasAndNotNull(jsonObject, "type") ? jsonObject.get("type").getAsString() : null).setVolume_percent(this.hasAndNotNull(jsonObject, "volume_percent") ? Integer.valueOf(jsonObject.get("volume_percent").getAsInt()) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private String id;
        private Boolean is_active;
        private Boolean is_private_session;
        private Boolean is_restricted;
        private String name;
        private Boolean supports_volume;
        private String type;
        private Integer volume_percent;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setIs_active(Boolean is_active) {
            this.is_active = is_active;
            return this;
        }

        public Builder setIs_private_session(Boolean is_private_session) {
            this.is_private_session = is_private_session;
            return this;
        }

        public Builder setIs_restricted(Boolean is_restricted) {
            this.is_restricted = is_restricted;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSupports_volume(Boolean supports_volume) {
            this.supports_volume = supports_volume;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setVolume_percent(Integer volume_percent) {
            this.volume_percent = volume_percent;
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }
    }
}

