/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import se.michaelthelin.spotify.SpotifyApi;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.IPlaylistItem;
import se.michaelthelin.spotify.model_objects.specification.User;
import se.michaelthelin.spotify.model_objects.utils.PlaylistItemFactory;

@JsonDeserialize(builder=Builder.class)
public class PlaylistTrack
extends AbstractModelObject {
    private final Date addedAt;
    private final User addedBy;
    private final Boolean isLocal;
    private final IPlaylistItem track;

    private PlaylistTrack(Builder builder) {
        super(builder);
        this.addedAt = builder.addedAt;
        this.addedBy = builder.addedBy;
        this.isLocal = builder.isLocal;
        this.track = builder.track;
    }

    public Date getAddedAt() {
        return this.addedAt;
    }

    public User getAddedBy() {
        return this.addedBy;
    }

    public Boolean getIsLocal() {
        return this.isLocal;
    }

    public IPlaylistItem getTrack() {
        return this.track;
    }

    @Override
    public String toString() {
        return "PlaylistTrack(track=" + this.track + ", addedAt=" + this.addedAt + ", addedBy=" + this.addedBy + ", isLocal=" + this.isLocal + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<PlaylistTrack> {
        @Override
        public PlaylistTrack createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            try {
                IPlaylistItem track = null;
                if (this.hasAndNotNull(jsonObject, "track")) {
                    JsonObject trackObj = jsonObject.getAsJsonObject("track");
                    track = PlaylistItemFactory.createPlaylistItem(trackObj);
                }
                return new Builder().setAddedAt(this.hasAndNotNull(jsonObject, "added_at") ? SpotifyApi.parseDefaultDate(jsonObject.get("added_at").getAsString()) : null).setAddedBy(this.hasAndNotNull(jsonObject, "added_by") ? new User.JsonUtil().createModelObject(jsonObject.get("added_by").getAsJsonObject()) : null).setIsLocal(this.hasAndNotNull(jsonObject, "is_local") ? Boolean.valueOf(jsonObject.get("is_local").getAsBoolean()) : null).setTrack(track).build();
            }
            catch (ParseException e) {
                SpotifyApi.LOGGER.log(Level.SEVERE, e.getMessage());
                return null;
            }
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private Date addedAt;
        private User addedBy;
        private Boolean isLocal;
        private IPlaylistItem track;

        public Builder setAddedAt(Date addedAt) {
            this.addedAt = addedAt;
            return this;
        }

        public Builder setAddedBy(User addedBy) {
            this.addedBy = addedBy;
            return this;
        }

        public Builder setIsLocal(Boolean isLocal) {
            this.isLocal = isLocal;
            return this;
        }

        public Builder setTrack(IPlaylistItem track) {
            this.track = track;
            return this;
        }

        @Override
        public PlaylistTrack build() {
            return new PlaylistTrack(this);
        }
    }
}

