/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.junit;

import cucumber.runtime.ClassFinder;
import cucumber.runtime.ParameterizableRuntime;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.junit.Assertions;
import cucumber.runtime.junit.ExamplesRunner;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.junit.ScenarioOutlineRunner;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import se.redmind.utils.Fields;

public class Cucumber
extends ParentRunner<FeatureRunner> {
    private final JUnitReporter jUnitReporter;
    private final List<FeatureRunner> children = new ArrayList<FeatureRunner>();
    private final ParameterizableRuntime runtime;
    private final String name;
    private final boolean reportRealClassNames;
    private final boolean hideStepsInReports;
    private final Object[] parameters;

    public Cucumber(Class clazz) throws InitializationError, IOException {
        this(clazz, null, new Object[0]);
    }

    public Cucumber(Class clazz, String name, Object ... parameters) throws InitializationError, IOException {
        super(clazz);
        this.name = name;
        this.parameters = parameters;
        this.reportRealClassNames = "true".equals(System.getProperty("reportRealClassNames"));
        this.hideStepsInReports = "true".equals(System.getProperty("hideStepsInReports"));
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.runtime = new ParameterizableRuntime((ResourceLoader)resourceLoader, (ClassFinder)new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader), classLoader, runtimeOptions, name, parameters);
        JUnitOptions junitOptions = new JUnitOptions(runtimeOptions.getJunitOptions());
        List<CucumberFeature> cucumberFeatures = this.runtime.cucumberFeatures();
        final Reporter reporter = runtimeOptions.reporter(classLoader);
        this.jUnitReporter = new JUnitReporter(reporter, runtimeOptions.formatter(classLoader), runtimeOptions.isStrict(), junitOptions){

            public void result(Result result) {
                if (Cucumber.this.hideStepsInReports) {
                    EachTestNotifier executionUnitNotifier;
                    Throwable error = result.getError();
                    if (error != null && (executionUnitNotifier = (EachTestNotifier)Fields.getValue((Object)((Object)this), (String)"executionUnitNotifier")) != null) {
                        executionUnitNotifier.addFailure(error);
                    }
                    reporter.result(result);
                } else {
                    super.result(result);
                }
            }
        };
        this.addChildren(cucumberFeatures);
    }

    public List<FeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.jUnitReporter.done();
        this.jUnitReporter.close();
        this.runtime.printSummary();
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            if (cucumberFeature.getFeatureElements().isEmpty()) continue;
            FeatureRunner featureRunner = new FeatureRunner(cucumberFeature, (Runtime)this.runtime, this.jUnitReporter);
            this.appendParameterizedName(featureRunner);
            this.children.add(featureRunner);
        }
    }

    private void appendParameterizedName(FeatureRunner featureRunner) throws InitializationError {
        List runners = (List)Fields.getValue((Object)featureRunner, (String)"children");
        CucumberFeature cucumberFeature = (CucumberFeature)Fields.getValue((Object)featureRunner, (String)"cucumberFeature");
        String featureName = ((String)Fields.getValue((Object)cucumberFeature, (String)"path")).replaceFirst(".feature$", "").replaceAll("/", ".");
        Map stepDefinitionsByPattern = (Map)Fields.getValue((Object)this.runtime.getGlue(), (String)"stepDefinitionsByPattern");
        for (int i = 0; i < runners.size(); ++i) {
            ParentRunner runner = (ParentRunner)runners.get(i);
            if (runner instanceof ExecutionUnitRunner) {
                runner = this.replaceExecutionRunner(featureName, stepDefinitionsByPattern, (ExecutionUnitRunner)runner);
            } else if (runner instanceof ScenarioOutlineRunner) {
                runner = this.replaceScenarioOutlineRunner(featureName, stepDefinitionsByPattern, (ScenarioOutlineRunner)runner);
            }
            runners.set(i, runner);
        }
    }

    private ExecutionUnitRunner replaceExecutionRunner(final String featureName, final Map<String, StepDefinition> stepDefinitionsByPattern, ExecutionUnitRunner runner) throws InitializationError {
        CucumberScenario cucumberScenario = (CucumberScenario)Fields.getValue((Object)runner, (String)"cucumberScenario");
        final Scenario scenario = (Scenario)Fields.getValue((Object)cucumberScenario, (String)"scenario");
        return new ExecutionUnitRunner(this.runtime, cucumberScenario, this.jUnitReporter){

            public Description getDescription() {
                Description description = super.getDescription();
                if (Cucumber.this.reportRealClassNames && !description.getClassName().equals(featureName)) {
                    Fields.set((Object)description, (String)"fDisplayName", (Object)(featureName + ":" + scenario.getLine() + (Cucumber.this.name != null ? Cucumber.this.name : "") + "(" + Cucumber.this.getTestClass().getJavaClass().getName() + ")"));
                }
                return description;
            }

            protected Description describeChild(Step step) {
                Description description = super.describeChild(step);
                if (!description.getMethodName().contains("#" + step.getLine())) {
                    Method method = this.findMatchingMethod(step);
                    if (Cucumber.this.reportRealClassNames && method != null) {
                        Fields.set((Object)description, (String)"fDisplayName", (Object)(method.getName() + "@" + featureName + "#" + step.getLine() + (Cucumber.this.name != null ? Cucumber.this.name : "") + "(" + method.getDeclaringClass().getName() + ")"));
                    } else {
                        Fields.set((Object)description, (String)"fDisplayName", (Object)(description.getMethodName() + "#" + step.getLine() + (Cucumber.this.name != null ? Cucumber.this.name : "") + "(" + description.getClassName() + ")"));
                    }
                }
                return description;
            }

            private Method findMatchingMethod(Step step) {
                Method method = null;
                for (Map.Entry entry : stepDefinitionsByPattern.entrySet()) {
                    if (!step.getName().matches((String)entry.getKey())) continue;
                    method = (Method)Fields.getValue(entry.getValue(), (String)"method");
                    break;
                }
                return method;
            }
        };
    }

    private ScenarioOutlineRunner replaceScenarioOutlineRunner(final String featureName, Map<String, StepDefinition> stepDefinitionsByPattern, ScenarioOutlineRunner runner) throws InitializationError {
        final CucumberScenarioOutline cucumberScenarioOutline = (CucumberScenarioOutline)Fields.getValue((Object)runner, (String)"cucumberScenarioOutline");
        ScenarioOutlineRunner scenarioOutlineRunner = new ScenarioOutlineRunner(this.runtime, cucumberScenarioOutline, this.jUnitReporter){

            public Description getDescription() {
                Description description;
                if (Cucumber.this.reportRealClassNames && (description = (Description)Fields.getValue((Object)((Object)this), (String)"description")) == null) {
                    description = Description.createSuiteDescription((String)this.getName(), (Serializable)cucumberScenarioOutline.getGherkinModel(), (Annotation[])new Annotation[0]);
                    List children = this.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        Runner child = (Runner)children.get(i);
                        Description childDescription = this.describeChild(child);
                        CucumberExamples cucumberExamples = (CucumberExamples)cucumberScenarioOutline.getCucumberExamplesList().get(i);
                        for (int j = 0; j < childDescription.getChildren().size(); ++j) {
                            Description exampleDescription = (Description)childDescription.getChildren().get(j);
                            ExamplesTableRow examplesTableRow = (ExamplesTableRow)cucumberExamples.getExamples().getRows().get(j);
                            Fields.set((Object)exampleDescription, (String)"fDisplayName", (Object)(featureName + ":" + examplesTableRow.getLine() + (Cucumber.this.name != null ? Cucumber.this.name : "") + "(" + Cucumber.this.getTestClass().getJavaClass().getName() + ")"));
                        }
                        description.addChild(childDescription);
                    }
                    Fields.set((Object)((Object)this), (String)"description", (Object)description);
                }
                return super.getDescription();
            }
        };
        List children = (List)Fields.getValue((Object)scenarioOutlineRunner, (String)"runners");
        for (ExamplesRunner child : children) {
            List currentRunners = (List)Fields.getValue((Object)child, (String)"runners");
            ArrayList<ExecutionUnitRunner> runners = new ArrayList<ExecutionUnitRunner>();
            for (ExecutionUnitRunner currentRunner : currentRunners) {
                runners.add(this.replaceExecutionRunner(featureName, stepDefinitionsByPattern, currentRunner));
            }
            Fields.set((Object)child, (String)"runners", runners);
        }
        return scenarioOutlineRunner;
    }
}

