/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import com.google.common.collect.Lists;
import cucumber.api.StepDefinitionReporter;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.Shellwords;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.ParameterizedJavaStepDefinition;
import cucumber.runtime.java.picocontainer.PicoFactory;
import cucumber.runtime.model.CucumberBackground;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberTagStatement;
import cucumber.runtime.model.ParameterizedStep;
import cucumber.runtime.model.StepContainer;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.redmind.rmtest.cucumber.utils.Tags;
import se.redmind.utils.Fields;
import se.redmind.utils.Methods;

public class ParameterizableRuntime
extends Runtime {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RuntimeOptions runtimeOptions;
    private final ClassLoader classLoader;
    private final ResourceLoader resourceLoader;
    private final String name;
    private final Object[] parameters;
    private PicoFactory picoFactory;

    public ParameterizableRuntime(ResourceLoader resourceLoader, ClassFinder classFinder, ClassLoader classLoader, RuntimeOptions runtimeOptions) {
        this(resourceLoader, classFinder, classLoader, runtimeOptions, null, new Object[0]);
    }

    public ParameterizableRuntime(ResourceLoader resourceLoader, ClassFinder classFinder, ClassLoader classLoader, RuntimeOptions runtimeOptions, String name, Object[] parameters) {
        super(resourceLoader, classFinder, classLoader, runtimeOptions);
        this.runtimeOptions = runtimeOptions;
        this.classLoader = classLoader;
        this.resourceLoader = resourceLoader;
        this.name = name;
        this.parameters = parameters;
    }

    public void run() throws IOException {
        List<CucumberFeature> features = this.cucumberFeatures();
        try (Formatter formatter = this.runtimeOptions.formatter(this.classLoader);){
            Reporter reporter = this.runtimeOptions.reporter(this.classLoader);
            StepDefinitionReporter stepDefinitionReporter = this.runtimeOptions.stepDefinitionReporter(this.classLoader);
            this.getGlue().reportStepDefinitions(stepDefinitionReporter);
            features.forEach(cucumberFeature -> cucumberFeature.run(formatter, reporter, (Runtime)this));
            formatter.done();
        }
        this.printSummary();
    }

    public Reporter reporter() {
        return this.runtimeOptions.reporter(this.classLoader);
    }

    public Formatter formatter() {
        return this.runtimeOptions.formatter(this.classLoader);
    }

    public List<CucumberFeature> cucumberFeatures() {
        List extraFilters = Shellwords.parse((String)System.getProperty("cucumber.filters", ""));
        block8: for (int i = 0; i < extraFilters.size(); i += 2) {
            String type;
            switch (type = ((String)extraFilters.get(i)).trim()) {
                case "--tags": {
                    this.runtimeOptions.getFilters().add(((String)extraFilters.get(i + 1)).trim());
                    continue block8;
                }
                case "--name": {
                    this.runtimeOptions.getFilters().add(Pattern.compile(((String)extraFilters.get(i + 1)).trim()));
                }
            }
        }
        boolean hasTags = this.runtimeOptions.getFilters().stream().filter(filter -> filter instanceof String).map(filter -> (String)filter).filter(filter -> filter.contains("@")).findFirst().map(filter -> true).orElse(false);
        if (hasTags || this.runtimeOptions.getFilters().isEmpty()) {
            this.runtimeOptions.getFilters().add("~@ignore");
            this.runtimeOptions.getFilters().add("~@parameterized");
        }
        ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>();
        cucumberFeatures.addAll(CucumberFeature.load((ResourceLoader)this.resourceLoader, (List)Lists.newArrayList((Object[])new String[]{"classpath:"}), (List)Lists.newArrayList((Object[])new Object[]{"@parameterized", "~@ignore"})));
        cucumberFeatures.addAll(this.runtimeOptions.cucumberFeatures(this.resourceLoader));
        Map<Pattern, ParameterizedJavaStepDefinition.Factory> parameterizedScenarios = this.getParameterizedScenarios(cucumberFeatures);
        if (!cucumberFeatures.isEmpty() && !parameterizedScenarios.isEmpty()) {
            this.inject(parameterizedScenarios, cucumberFeatures);
        }
        return cucumberFeatures;
    }

    public void buildBackendWorlds(Reporter reporter, Set<Tag> tags, Scenario gherkinScenario) {
        for (Object parameter : this.parameters) {
            this.picoFactory().addInstance(parameter);
        }
        super.buildBackendWorlds(reporter, tags, gherkinScenario);
    }

    public Map<Pattern, ParameterizedJavaStepDefinition.Factory> getParameterizedScenarios(List<CucumberFeature> features) {
        LinkedHashMap<Pattern, ParameterizedJavaStepDefinition.Factory> parameterizedScenarios = new LinkedHashMap<Pattern, ParameterizedJavaStepDefinition.Factory>();
        for (int i = 0; i < features.size(); ++i) {
            CucumberFeature feature = features.get(i);
            List statements = feature.getFeatureElements();
            for (int j = 0; j < statements.size(); ++j) {
                CucumberTagStatement statement = (CucumberTagStatement)statements.get(j);
                if (Tags.isParameterized(statement)) {
                    ParameterizedJavaStepDefinition.Factory stepFactory = ParameterizedJavaStepDefinition.from(statement, this);
                    parameterizedScenarios.put(stepFactory.pattern(), stepFactory);
                    statements.remove(j--);
                    continue;
                }
                if (this.name == null) continue;
                TagStatement tagStatement = statement.getGherkinModel();
                Fields.set((Object)tagStatement, (String)"name", (Object)(tagStatement.getName() + " " + this.name));
            }
            if (!statements.isEmpty()) continue;
            features.remove(i--);
        }
        if (!features.isEmpty() && !parameterizedScenarios.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            int maxLength = parameterizedScenarios.values().stream().map(f -> f.statement().getVisualName().length()).max(Integer::compareTo).orElse(0);
            parameterizedScenarios.values().forEach(factory -> {
                CucumberFeature cucumberFeature = (CucumberFeature)Fields.getValue((Object)factory.statement(), (String)"cucumberFeature");
                String path = (String)Fields.getValue((Object)cucumberFeature, (String)"path");
                String visualName = factory.statement().getVisualName().replaceAll("Scenario:", "");
                stringBuilder.append("\n  ").append(visualName);
                for (int i = 0; i < maxLength - visualName.length() - 5; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append("# ").append(path).append(":").append(factory.statement().getGherkinModel().getLine());
            });
            this.logger.info("\nregistering parameterized scenarios:" + stringBuilder.toString() + "\n");
        }
        return parameterizedScenarios;
    }

    public void inject(Map<Pattern, ParameterizedJavaStepDefinition.Factory> parameterizedScenarios, List<CucumberFeature> features) throws RuntimeException {
        CompositionType compositionType = CompositionType.valueOf(System.getProperty("cucumber.compositionType", CompositionType.replace.name()));
        if (compositionType == CompositionType.full) {
            this.picoFactory().addInstance((Object)this);
            this.getGlue().addStepDefinition((StepDefinition)new ParameterizedJavaStepDefinition(Methods.findMethod(((Object)((Object)this)).getClass(), (String)"endOfParameterizedScenario", (Class[])new Class[0]), Pattern.compile("}"), 0L, this.picoFactory()));
        }
        features.forEach(feature -> {
            int modifiedSteps;
            ArrayList<CucumberBackground> stepContainers = new ArrayList<CucumberBackground>(feature.getFeatureElements());
            CucumberBackground cucumberBackground = (CucumberBackground)Fields.getValue((Object)feature, (String)"cucumberBackground");
            if (cucumberBackground != null) {
                stepContainers.add(cucumberBackground);
            }
            parameterizedScenarios.values().forEach(scenario -> stepContainers.add((CucumberBackground)scenario.statement()));
            do {
                modifiedSteps = 0;
                for (StepContainer stepContainer : stepContainers) {
                    for (int i = 0; i < stepContainer.getSteps().size(); ++i) {
                        Step step = (Step)stepContainer.getSteps().get(i);
                        if (step instanceof ParameterizedStep && (((ParameterizedStep)step).getType() == ParameterizedStep.Type.Start || ((ParameterizedStep)step).getType() == ParameterizedStep.Type.Quiet)) continue;
                        String stepName = step.getName();
                        for (Map.Entry parameterizedScenario : parameterizedScenarios.entrySet()) {
                            Function<Step, ParameterizedStep> wrapper;
                            Matcher matcher = ((Pattern)parameterizedScenario.getKey()).matcher(stepName);
                            if (!matcher.matches()) continue;
                            String[] names = ((ParameterizedJavaStepDefinition.Factory)parameterizedScenario.getValue()).parameters();
                            Object[] scenarioParameters = new Object[names.length];
                            for (int k = 0; k < names.length; ++k) {
                                String value = matcher.group(k + 1);
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                scenarioParameters[k] = value;
                            }
                            if (compositionType == CompositionType.full) {
                                ((ParameterizedJavaStepDefinition.Factory)parameterizedScenario.getValue()).addStartStepToGlue();
                                stepContainer.getSteps().set(i, ParameterizedStep.startOf(step));
                                wrapper = parameterizedStep -> ParameterizedStep.asSubStep(parameterizedStep, names, scenarioParameters);
                            } else {
                                stepContainer.getSteps().remove(i--);
                                wrapper = parameterizedStep -> ParameterizedStep.parameterize(parameterizedStep, names, scenarioParameters);
                            }
                            List newSteps = ((ParameterizedJavaStepDefinition.Factory)parameterizedScenario.getValue()).statement().getSteps().stream().map(wrapper).collect(Collectors.toList());
                            stepContainer.getSteps().addAll(i + 1, newSteps);
                            i += newSteps.size();
                            if (compositionType == CompositionType.full) {
                                stepContainer.getSteps().add(++i, ParameterizedStep.endOf(step));
                            }
                            ++modifiedSteps;
                        }
                    }
                }
            } while (modifiedSteps > 0);
        });
    }

    public void endOfParameterizedScenario() {
    }

    public PicoFactory picoFactory() throws RuntimeException {
        if (this.picoFactory == null) {
            Collection backends = (Collection)Fields.getValue((Object)((Object)this), (String)"backends");
            Optional<JavaBackend> first = backends.stream().filter(backend -> backend instanceof JavaBackend).map(backend -> (JavaBackend)backend).findFirst();
            if (first.isPresent()) {
                this.picoFactory = (PicoFactory)Fields.getValue((Object)first.get(), (String)"objectFactory");
            } else {
                throw new RuntimeException("can't find a javaBackend instance");
            }
        }
        return this.picoFactory;
    }

    public static enum CompositionType {
        replace,
        full;

    }
}

