/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import java.util.LinkedList;

public interface StopWatch {
    public static final StopWatch SYSTEM = new StopWatch(){
        private final ThreadLocal<LinkedList<Long>> start = ThreadLocal.withInitial(LinkedList::new);

        @Override
        public void start() {
            this.start.get().add(System.nanoTime());
        }

        @Override
        public long stop() {
            return System.nanoTime() - this.start.get().removeLast();
        }
    };

    public void start();

    public long stop();

    public static class Stub
    implements StopWatch {
        private final long duration;

        public Stub(long duration) {
            this.duration = duration;
        }

        @Override
        public void start() {
        }

        @Override
        public long stop() {
            return this.duration;
        }
    }
}

