/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.formatter.HTMLFormatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import java.net.URL;

public class NonRepeatingHTMLFormatter
extends HTMLFormatter {
    private boolean backgroundHasBeenPrinted;
    private boolean printing = true;

    public NonRepeatingHTMLFormatter(URL htmlReportDir) {
        super(htmlReportDir);
    }

    public void feature(Feature feature) {
        super.feature(feature);
        this.backgroundHasBeenPrinted = false;
    }

    public void background(Background background) {
        if (this.backgroundHasBeenPrinted) {
            this.printing = false;
        } else {
            super.background(background);
        }
        this.backgroundHasBeenPrinted = true;
    }

    public void scenario(Scenario scenario) {
        this.printing = true;
        super.scenario(scenario);
    }

    public void step(Step step) {
        if (this.printing) {
            super.step(step);
        }
    }

    public void match(Match match) {
        if (this.printing) {
            super.match(match);
        }
    }
}

