/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.ParameterizableRuntime;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.model.CucumberTagStatement;
import gherkin.formatter.model.TagStatement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import se.redmind.utils.Fields;
import se.redmind.utils.Methods;

public class ParameterizedJavaStepDefinition
extends JavaStepDefinition {
    public ParameterizedJavaStepDefinition(Method method, Pattern pattern, long timeoutMillis, ObjectFactory objectFactory) {
        super(method, pattern, timeoutMillis, objectFactory);
    }

    public static Factory from(CucumberTagStatement statement, ParameterizableRuntime runtime) {
        TagStatement tagStatement = (TagStatement)Fields.getValue((Object)statement, (String)"statement");
        String name = tagStatement.getName().replaceAll("(Given|When|Then|And|\\*)", "");
        StringBuilder patternBuilder = new StringBuilder("^(?:that )?");
        StringBuilder parameterBuilder = new StringBuilder();
        ArrayList<String> parametersNames = new ArrayList<String>();
        boolean inParameter = false;
        boolean inQuotes = false;
        block5: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '<': {
                    if (inParameter) {
                        throw new IllegalArgumentException("error while parsing " + name);
                    }
                    inParameter = true;
                    patternBuilder.append("(");
                    if (inQuotes) {
                        patternBuilder.append(".*");
                    } else {
                        patternBuilder.append("[0-9]+|[0-9]*\\.[0-9]+|\\S+");
                    }
                    patternBuilder.append(")");
                    continue block5;
                }
                case '>': {
                    if (!inParameter) {
                        throw new IllegalArgumentException("error while parsing " + name);
                    }
                    inParameter = false;
                    parametersNames.add(parameterBuilder.toString());
                    parameterBuilder = new StringBuilder();
                    continue block5;
                }
                case '\"': {
                    if (i > 1 && name.charAt(i - 1) == '>' || i < name.length() - 1 && name.charAt(i + 1) == '<') {
                        inQuotes ^= true;
                    }
                }
                default: {
                    if (!inParameter) {
                        patternBuilder.append(c);
                        continue block5;
                    }
                    parameterBuilder.append(c);
                }
            }
        }
        return new Factory(statement, Pattern.compile(patternBuilder.append("$").toString()), parametersNames.toArray(new String[0]), runtime);
    }

    public static class Factory {
        private final CucumberTagStatement statement;
        private final Pattern pattern;
        private final String[] parameters;
        private final ParameterizableRuntime runtime;
        private Class<?> clazz;
        private Class<?>[] parametersClasses;
        private ParameterizedJavaStepDefinition start;

        public Factory(CucumberTagStatement statement, Pattern pattern, String[] parameters, ParameterizableRuntime runtime) {
            this.statement = statement;
            this.pattern = pattern;
            this.parameters = parameters;
            this.runtime = runtime;
        }

        public CucumberTagStatement statement() {
            return this.statement;
        }

        public Pattern pattern() {
            return this.pattern;
        }

        public String[] parameters() {
            return this.parameters;
        }

        private synchronized Class<?> clazz() {
            if (this.clazz == null) {
                try {
                    StringBuilder parametersListBuilder;
                    StringBuilder parametersNamesBuilder;
                    this.parametersClasses = new Class[this.parameters.length];
                    StringBuilder parametersBuilder = new StringBuilder();
                    if (this.parameters.length > 0) {
                        parametersNamesBuilder = new StringBuilder("new String[]{");
                        for (String parameter : this.parameters) {
                            if (parametersNamesBuilder.length() > 13) {
                                parametersNamesBuilder.append(", ");
                            }
                            parametersNamesBuilder.append("\"").append(parameter).append("\"");
                        }
                        parametersNamesBuilder.append("}");
                        parametersListBuilder = new StringBuilder("new Object[]{");
                        for (int i = 0; i < this.parameters.length; ++i) {
                            if (parametersBuilder.length() > 0) {
                                parametersBuilder.append(", ");
                                parametersListBuilder.append(", ");
                            }
                            parametersBuilder.append("String arg").append(i);
                            parametersListBuilder.append("arg").append(i);
                            this.parametersClasses[i] = String.class;
                        }
                        parametersListBuilder.append("}");
                    } else {
                        parametersNamesBuilder = new StringBuilder("new String[0]");
                        parametersListBuilder = new StringBuilder("new Object[0]");
                    }
                    ClassPool pool = ClassPool.getDefault();
                    String className = "cucumber.runtime.model.ParameterizedScenario$" + Integer.toHexString(this.statement.hashCode());
                    CtClass ctClass = pool.getOrNull(className);
                    if (ctClass == null) {
                        ctClass = pool.makeClass(className);
                        ctClass.addField(CtField.make((String)"public static cucumber.runtime.model.StepContainer STEPCONTAINER;", (CtClass)ctClass));
                        ctClass.addField(CtField.make((String)"public static cucumber.runtime.ParameterizableRuntime RUNTIME;", (CtClass)ctClass));
                        ctClass.addMethod(CtNewMethod.make((String)("public void execute(" + parametersBuilder.toString() + ") {\n" + "     cucumber.runtime.model.ParameterizedStepContainer parameterizedStepContainer = " + "new cucumber.runtime.model.ParameterizedStepContainer(STEPCONTAINER, " + parametersNamesBuilder.toString() + ", " + parametersListBuilder.toString() + ");\n" + "     se.redmind.utils.Methods.invoke(parameterizedStepContainer, \"format\", new Object[] { RUNTIME.formatter() });\n" + "     se.redmind.utils.Methods.invoke(parameterizedStepContainer, \"runSteps\", new Object[] { RUNTIME.reporter(), RUNTIME });\n" + "}"), (CtClass)ctClass));
                        ctClass.addMethod(CtNewMethod.make((String)("public void start(" + parametersBuilder.toString() + ") {}"), (CtClass)ctClass));
                        this.clazz = ctClass.toClass();
                        this.clazz.getDeclaredField("STEPCONTAINER").set(null, this.statement);
                        this.clazz.getDeclaredField("RUNTIME").set(null, (Object)this.runtime);
                    } else {
                        this.clazz = Class.forName(className);
                    }
                    this.runtime.picoFactory().addClass(this.clazz);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | CannotCompileException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return this.clazz;
        }

        public synchronized ParameterizedJavaStepDefinition addStartStepToGlue() {
            if (this.start == null) {
                this.start = new ParameterizedJavaStepDefinition(Methods.findMethod(this.clazz(), (String)"start", (Class[])this.parametersClasses), Pattern.compile(this.pattern.pattern().substring(0, this.pattern.pattern().length() - 1) + "(?: \\{)$"), 0L, this.runtime.picoFactory());
                this.runtime.getGlue().addStepDefinition((StepDefinition)this.start);
            }
            return this.start;
        }
    }
}

