/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.picocontainer;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.Utils;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoBuilder;

public class PicoFactory
implements ObjectFactory {
    private MutablePicoContainer pico;
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Map<Class<?>, Object> instances = new LinkedHashMap();

    public void start() {
        this.pico = new PicoBuilder().withCaching().build();
        this.instances.keySet().forEach(this.classes::remove);
        this.classes.forEach(clazz -> this.pico.addComponent(clazz));
        this.instances.forEach((clazz, instance) -> this.pico.addComponent(clazz, instance, new Parameter[0]));
        this.pico.start();
    }

    public void stop() {
        this.pico.stop();
        this.pico.dispose();
    }

    public boolean addClass(Class<?> clazz) {
        if (Utils.isInstantiable(clazz) && this.classes.add(clazz)) {
            this.addConstructorDependencies(clazz);
        }
        return true;
    }

    public boolean addInstance(Object instance) {
        this.instances.put(instance.getClass(), instance);
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.pico.getComponent(type);
    }

    private void addConstructorDependencies(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (Class<?> paramClazz : constructor.getParameterTypes()) {
                this.addClass(paramClazz);
            }
        }
    }
}

