/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.model.ParameterizedStepContainer;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Step;
import java.util.List;

public class ParameterizedStep
extends Step {
    private static final ThreadLocal<Integer> depth = ThreadLocal.withInitial(() -> 0);
    private final Type type;

    private ParameterizedStep(List<Comment> comments, String keyword, String name, Integer line, List<DataTableRow> rows, DocString docString, Type type) {
        super(comments, keyword, name, line, rows, docString);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        switch (this.type) {
            case Start: {
                return super.getName() + " {";
            }
            case End: {
                return "}";
            }
        }
        return super.getName();
    }

    public String getKeyword() {
        String keyword;
        switch (this.type) {
            case Start: {
                keyword = this.addDepthTabs(super.getKeyword(), depth.get());
                depth.set(depth.get() + 1);
                break;
            }
            case End: {
                depth.set(depth.get() - 1);
                keyword = this.addDepthTabs("", depth.get());
                break;
            }
            default: {
                keyword = this.addDepthTabs(super.getKeyword(), depth.get());
            }
        }
        return keyword;
    }

    private String addDepthTabs(String input, int depthValue) {
        StringBuilder output = new StringBuilder(input);
        for (int i = 0; i < depthValue; ++i) {
            output.insert(0, "  ");
        }
        return output.toString();
    }

    public static ParameterizedStep startOf(Step step) {
        return new ParameterizedStep(step.getComments(), step.getKeyword(), step.getName().replaceAll("@full", "").trim(), step.getLine(), step.getRows(), step.getDocString(), Type.Start);
    }

    public static ParameterizedStep asSubStep(Step step, String[] names, Object[] parameters) {
        return new ParameterizedStep(step.getComments(), step.getKeyword(), ParameterizedStepContainer.replacePlaceHolders(step.getName(), names, parameters), step.getLine(), step.getRows(), ParameterizedStep.parameterizeDocString(step.getDocString(), names, parameters), Type.SubStep);
    }

    public static ParameterizedStep parameterize(Step step, String[] names, Object[] parameters) {
        return new ParameterizedStep(step.getComments(), step.getKeyword(), ParameterizedStepContainer.replacePlaceHolders(step.getName(), names, parameters), step.getLine(), step.getRows(), ParameterizedStep.parameterizeDocString(step.getDocString(), names, parameters), Type.Parameterized);
    }

    public static ParameterizedStep endOf(Step step) {
        return new ParameterizedStep(step.getComments(), step.getKeyword(), step.getName().replaceAll("@full", "").trim(), step.getLine(), step.getRows(), step.getDocString(), Type.End);
    }

    private static DocString parameterizeDocString(DocString docString, String[] names, Object[] parameters) {
        return docString == null ? null : new DocString(docString.getContentType(), ParameterizedStepContainer.replacePlaceHolders(docString.getValue(), names, parameters), Integer.valueOf(docString.getLine()));
    }

    public static enum Type {
        Start,
        SubStep,
        Parameterized,
        Quiet,
        End;

    }
}

