/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.formatter.AnsiFormats;
import gherkin.formatter.Argument;
import gherkin.formatter.Format;
import gherkin.formatter.Formats;
import gherkin.formatter.Formatter;
import gherkin.formatter.MatchResultPair;
import gherkin.formatter.MonochromeFormats;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.StepPrinter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.CellResult;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DescribedStatement;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class PrettyFormatter
implements Reporter,
Formatter {
    private final StepPrinter stepPrinter = new StepPrinter();
    private final NiceAppendable out;
    private final boolean executing;
    private String uri;
    private final Mapper<Tag, String> tagNameMapper = Tag::getName;
    private Formats formats;
    private Match match;
    private int[][] cellLengths;
    private int[] maxLengths;
    private int rowIndex;
    private List<? extends Row> rows;
    private Integer rowHeight = null;
    private boolean rowsAbove = false;
    private final List<Step> steps = new ArrayList<Step>();
    private final List<Integer> indentations = new ArrayList<Integer>();
    private final List<MatchResultPair> matchesAndResults = new ArrayList<MatchResultPair>();
    private DescribedStatement statement;
    private boolean backgroundHasBeenPrinted;
    private boolean printing = true;
    private static final Pattern START = Pattern.compile("^", 8);
    private static final Pattern TRIPLE_QUOTES = Pattern.compile("\"\"\"", 8);
    private static final String ESCAPED_TRIPLE_QUOTES = "\\\\\"\\\\\"\\\\\"";

    public PrettyFormatter(Appendable out, boolean monochrome, boolean executing) {
        this.out = new NiceAppendable(out);
        this.executing = executing;
        this.setMonochrome(monochrome);
    }

    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }

    public void uri(String uri) {
        this.uri = uri;
    }

    public void feature(Feature feature) {
        this.printComments(feature.getComments(), "");
        this.printTags(feature.getTags(), "");
        this.out.println((CharSequence)(feature.getKeyword() + ": " + feature.getName()));
        this.printDescription(feature.getDescription(), "  ", false);
        this.backgroundHasBeenPrinted = false;
    }

    public void background(Background background) {
        this.replay();
        this.statement = background;
        if (this.backgroundHasBeenPrinted) {
            this.printing = false;
        }
        this.backgroundHasBeenPrinted = true;
    }

    public void scenario(Scenario scenario) {
        this.replay();
        this.statement = scenario;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.replay();
        this.statement = scenarioOutline;
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    private void replay() {
        this.addAnyOrphanMatch();
        this.printStatement();
        this.printSteps();
    }

    private void printSteps() {
        if (!this.printing) {
            this.steps.clear();
            this.matchesAndResults.clear();
        }
        while (!this.steps.isEmpty()) {
            if (this.matchesAndResults.isEmpty()) {
                this.printStep("skipped", Collections.emptyList(), null);
                continue;
            }
            MatchResultPair matchAndResult = this.matchesAndResults.remove(0);
            this.printStep(matchAndResult.getResultStatus(), matchAndResult.getMatchArguments(), matchAndResult.getMatchLocation());
            if (!matchAndResult.hasResultErrorMessage()) continue;
            this.printError(matchAndResult.result);
        }
    }

    private void printStatement() {
        if (this.statement == null) {
            return;
        }
        if (!this.printing) {
            if (this.statement instanceof Scenario || this.statement instanceof ScenarioOutline) {
                this.printing = true;
            } else {
                return;
            }
        }
        this.calculateLocationIndentations();
        this.out.println();
        this.printComments(this.statement.getComments(), "  ");
        if (this.statement instanceof TagStatement) {
            this.printTags(((TagStatement)this.statement).getTags(), "  ");
        }
        StringBuilder buffer = new StringBuilder("  ");
        buffer.append(this.statement.getKeyword());
        buffer.append(": ");
        buffer.append(this.statement.getName());
        String location = this.executing ? this.uri + ":" + this.statement.getLine() : null;
        buffer.append(this.indentedLocation(location));
        this.out.println((CharSequence)buffer);
        this.printDescription(this.statement.getDescription(), "    ", true);
        this.statement = null;
    }

    private String indentedLocation(String location) {
        int indentation;
        StringBuilder sb = new StringBuilder();
        int n = indentation = this.indentations.isEmpty() ? 0 : this.indentations.remove(0);
        if (location == null) {
            return "";
        }
        for (int i = 0; i < indentation; ++i) {
            sb.append(' ');
        }
        sb.append(' ');
        sb.append(this.getFormat("comment").text("# " + location));
        return sb.toString();
    }

    public void examples(Examples examples) {
        this.replay();
        this.out.println();
        this.printComments(examples.getComments(), "    ");
        this.printTags(examples.getTags(), "    ");
        this.out.println((CharSequence)("    " + examples.getKeyword() + ": " + examples.getName()));
        this.printDescription(examples.getDescription(), "      ", true);
        this.table(examples.getRows());
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    public void match(Match match) {
        this.addAnyOrphanMatch();
        this.match = match;
    }

    private void addAnyOrphanMatch() {
        if (this.match != null) {
            this.matchesAndResults.add(new MatchResultPair(this.match, null));
        }
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
        this.out.println((CharSequence)this.getFormat("output").text(text));
    }

    public void result(Result result) {
        this.matchesAndResults.add(new MatchResultPair(this.match, result));
        this.match = null;
    }

    public void before(Match match, Result result) {
        this.printHookFailure(match, result, true);
    }

    public void after(Match match, Result result) {
        this.printHookFailure(match, result, false);
    }

    private void printHookFailure(Match match, Result result, boolean isBefore) {
        if (result.getStatus().equals("failed")) {
            Format format = this.getFormat(result.getStatus());
            StringBuilder context = new StringBuilder("Failure in ");
            if (isBefore) {
                context.append("before");
            } else {
                context.append("after");
            }
            context.append(" hook:");
            this.out.println((CharSequence)(format.text(context.toString()) + format.text(match.getLocation())));
            this.out.println((CharSequence)(format.text("Message: ") + format.text(result.getErrorMessage())));
            if (result.getError() != null) {
                this.printError(result);
            }
        }
    }

    private void printStep(String status, List<Argument> arguments, String location) {
        Step step = this.steps.remove(0);
        Format textFormat = this.getFormat(status);
        Format argFormat = this.getArgFormat(status);
        this.printComments(step.getComments(), "    ");
        StringBuilder buffer = new StringBuilder("    ");
        buffer.append(textFormat.text(step.getKeyword()));
        this.stepPrinter.writeStep(new NiceAppendable((Appendable)buffer), textFormat, argFormat, step.getName(), arguments);
        buffer.append(this.indentedLocation(location));
        this.out.println((CharSequence)buffer);
        if (step.getRows() != null) {
            this.table(step.getRows());
        } else if (step.getDocString() != null) {
            this.docString(step.getDocString());
        }
    }

    private Format getFormat(String key) {
        return this.formats.get(key);
    }

    private Format getArgFormat(String key) {
        return this.formats.get(key + "_arg");
    }

    public void table(List<? extends Row> rows) {
        this.prepareTable(rows);
        rows.forEach(row -> {
            this.row(row.createResults("skipped"));
            this.nextRow();
        });
    }

    private void prepareTable(List<? extends Row> rows) {
        this.rows = rows;
        int columnCount = 0;
        for (Row row : rows) {
            if (columnCount >= row.getCells().size()) continue;
            columnCount = row.getCells().size();
        }
        this.cellLengths = new int[rows.size()][columnCount];
        this.maxLengths = new int[columnCount];
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            Row row = rows.get(rowIndex);
            List cells = row.getCells();
            for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                int length;
                String cell = this.getCellSafely(cells, colIndex);
                this.cellLengths[rowIndex][colIndex] = length = this.escapeCell(cell).length();
                this.maxLengths[colIndex] = Math.max(this.maxLengths[colIndex], length);
            }
        }
        this.rowIndex = 0;
    }

    private String getCellSafely(List<String> cells, int colIndex) {
        return colIndex < cells.size() ? cells.get(colIndex) : "";
    }

    public void row(List<CellResult> cellResults) {
        StringBuilder buffer = new StringBuilder();
        Row row = this.rows.get(this.rowIndex);
        if (this.rowsAbove) {
            buffer.append(this.formats.up(this.rowHeight.intValue()));
        } else {
            this.rowsAbove = true;
        }
        this.rowHeight = 1;
        row.getComments().forEach(comment -> {
            buffer.append("      ");
            buffer.append(comment.getValue());
            buffer.append("\n");
            Integer n = this.rowHeight;
            Integer n2 = this.rowHeight = Integer.valueOf(this.rowHeight + 1);
        });
        switch (row.getDiffType()) {
            case NONE: {
                buffer.append("      | ");
                break;
            }
            case DELETE: {
                buffer.append("    ").append(this.formats.get("skipped").text("-")).append(" | ");
                break;
            }
            case INSERT: {
                buffer.append("    ").append(this.formats.get("comment").text("+")).append(" | ");
            }
        }
        for (int colIndex = 0; colIndex < this.maxLengths.length; ++colIndex) {
            String cellText = this.escapeCell(this.getCellSafely(row.getCells(), colIndex));
            String status = null;
            switch (row.getDiffType()) {
                case NONE: {
                    status = cellResults.size() < colIndex ? cellResults.get(colIndex).getStatus() : "skipped";
                    break;
                }
                case DELETE: {
                    status = "skipped";
                    break;
                }
                case INSERT: {
                    status = "comment";
                }
            }
            Format format = this.formats.get(status);
            buffer.append(format.text(cellText));
            int padding = this.maxLengths[colIndex] - this.cellLengths[this.rowIndex][colIndex];
            this.padSpace(buffer, padding);
            if (colIndex < this.maxLengths.length - 1) {
                buffer.append(" | ");
                continue;
            }
            buffer.append(" |");
        }
        this.out.println((CharSequence)buffer);
        Integer colIndex = this.rowHeight;
        Integer n = this.rowHeight = Integer.valueOf(this.rowHeight + 1);
        HashSet seenResults = new HashSet();
        cellResults.forEach(cellResult -> cellResult.getResults().stream().filter(result -> result.getErrorMessage() != null && !seenResults.contains(result)).forEach(result -> {
            this.printError((Result)result);
            this.rowHeight = this.rowHeight + result.getErrorMessage().split("\n").length;
            seenResults.add(result);
        }));
    }

    private void printError(Result result) {
        Format failed = this.formats.get("failed");
        this.out.println((CharSequence)PrettyFormatter.indent(failed.text(result.getErrorMessage()), "      "));
    }

    public void nextRow() {
        ++this.rowIndex;
        this.rowsAbove = false;
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        throw new UnsupportedOperationException();
    }

    public void done() {
    }

    public void close() {
        this.out.close();
    }

    private String escapeCell(String cell) {
        return cell.replaceAll("\\\\(?!\\|)", "\\\\\\\\").replaceAll("\\n", "\\\\n").replaceAll("\\|", "\\\\|");
    }

    public void docString(DocString docString) {
        this.out.println((CharSequence)"      \"\"\"");
        this.out.println((CharSequence)PrettyFormatter.escapeTripleQuotes(PrettyFormatter.indent(docString.getValue(), "      ")));
        this.out.println((CharSequence)"      \"\"\"");
    }

    public void eof() {
        this.replay();
    }

    private void calculateLocationIndentations() {
        int[] lineWidths = new int[this.steps.size() + 1];
        int i = 0;
        ArrayList<Object> statements = new ArrayList<Object>();
        statements.add(this.statement);
        statements.addAll(this.steps);
        int maxLineWidth = 0;
        for (BasicStatement basicStatement : statements) {
            int stepWidth = basicStatement.getKeyword().length() + basicStatement.getName().length();
            lineWidths[i++] = stepWidth;
            maxLineWidth = Math.max(maxLineWidth, stepWidth);
        }
        for (Object lineWidth : (Object)lineWidths) {
            this.indentations.add(maxLineWidth - lineWidth);
        }
    }

    private void padSpace(StringBuilder buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
    }

    private void printComments(List<Comment> comments, String indent) {
        comments.forEach(comment -> this.out.println((CharSequence)(indent + comment.getValue())));
    }

    private void printTags(List<Tag> tags, String indent) {
        if (tags.isEmpty()) {
            return;
        }
        this.out.println((CharSequence)(indent + FixJava.join((List)FixJava.map(tags, this.tagNameMapper), (String)" ")));
    }

    private void printDescription(String description, String indentation, boolean newline) {
        if (!"".equals(description)) {
            this.out.println((CharSequence)PrettyFormatter.indent(description, indentation));
            if (newline) {
                this.out.println();
            }
        }
    }

    private static String indent(String s, String indentation) {
        return START.matcher(s).replaceAll(indentation);
    }

    private static String escapeTripleQuotes(String s) {
        return TRIPLE_QUOTES.matcher(s).replaceAll(ESCAPED_TRIPLE_QUOTES);
    }
}

