/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.agp.test.consumer;

import org.junit.Assert;
import org.soitoolkit.commons.mule.test.AbstractJmsTestUtil;
import org.soitoolkit.commons.mule.test.ActiveMqJmsTestUtil;
import org.soitoolkit.commons.mule.test.junit4.AbstractTestCase;
import se.skltp.agp.riv.interoperability.headers.v1.CausingAgentEnum;
import se.skltp.agp.riv.interoperability.headers.v1.LastUnsuccessfulSynchErrorType;
import se.skltp.agp.riv.interoperability.headers.v1.ProcessingStatusRecordType;
import se.skltp.agp.riv.interoperability.headers.v1.StatusCodeEnum;
import se.skltp.agp.test.producer.TestProducerDb;

public abstract class AbstractAggregateIntegrationTest
extends AbstractTestCase {
    private static final String ERROR_LOG_QUEUE = "SOITOOLKIT.LOG.ERROR";
    private AbstractJmsTestUtil jmsUtil = null;

    public AbstractAggregateIntegrationTest() {
        this.setDisposeContextPerClass(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (this.jmsUtil == null) {
            this.jmsUtil = new ActiveMqJmsTestUtil();
        }
        this.jmsUtil.clearQueues(new String[]{ERROR_LOG_QUEUE});
    }

    protected TestProducerDb getTestDb() {
        return (TestProducerDb)muleContext.getRegistry().lookupObject("service-producer-testdb-bean");
    }

    protected void assertProcessingStatusDataFromSource(ProcessingStatusRecordType status, String logicalAddress) {
        Assert.assertEquals((Object)logicalAddress, (Object)status.getLogicalAddress());
        Assert.assertEquals((Object)StatusCodeEnum.DATA_FROM_SOURCE, (Object)status.getStatusCode());
        Assert.assertFalse((boolean)status.isIsResponseFromCache());
        Assert.assertTrue((boolean)status.isIsResponseInSynch());
        Assert.assertNotNull((Object)status.getLastSuccessfulSynch());
        Assert.assertNull((Object)status.getLastUnsuccessfulSynch());
        Assert.assertNull((Object)status.getLastUnsuccessfulSynchError());
    }

    protected void assertProcessingStatusDataFromCache(ProcessingStatusRecordType status, String logicalAddress) {
        Assert.assertEquals((Object)logicalAddress, (Object)status.getLogicalAddress());
        Assert.assertEquals((Object)StatusCodeEnum.DATA_FROM_CACHE, (Object)status.getStatusCode());
        Assert.assertTrue((boolean)status.isIsResponseFromCache());
        Assert.assertTrue((boolean)status.isIsResponseInSynch());
        Assert.assertNotNull((Object)status.getLastSuccessfulSynch());
        Assert.assertNull((Object)status.getLastUnsuccessfulSynch());
        Assert.assertNull((Object)status.getLastUnsuccessfulSynchError());
    }

    protected void assertProcessingStatusNoDataSynchFailed(ProcessingStatusRecordType status, String logicalAddress, CausingAgentEnum agent, String expectedErrStartingWith) {
        Assert.assertEquals((Object)logicalAddress, (Object)status.getLogicalAddress());
        Assert.assertEquals((Object)StatusCodeEnum.NO_DATA_SYNCH_FAILED, (Object)status.getStatusCode());
        Assert.assertFalse((boolean)status.isIsResponseFromCache());
        Assert.assertFalse((boolean)status.isIsResponseInSynch());
        Assert.assertNull((Object)status.getLastSuccessfulSynch());
        Assert.assertNotNull((Object)status.getLastUnsuccessfulSynch());
        LastUnsuccessfulSynchErrorType error = status.getLastUnsuccessfulSynchError();
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)agent, (Object)error.getCausingAgent());
        Assert.assertNotNull((Object)error.getCode());
        Assert.assertTrue((String)("Missing expected [" + expectedErrStartingWith + "] in the beginning if the error message [" + error.getText() + "]"), (boolean)error.getText().startsWith(expectedErrStartingWith));
    }
}

