/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.agp.test.producer;

import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProducerLogger
extends AbstractMessageTransformer {
    private static final Logger log = LoggerFactory.getLogger(TestProducerLogger.class);
    private static String lastSenderId = null;
    private static String lastOriginalConsumer = null;
    private static String lastVpInstance = null;

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Map httpHeaders = (Map)message.getInboundProperty("http.headers");
        String senderId = (String)httpHeaders.get("x-vp-sender-id");
        log.info("Test producer called with {}: {}", (Object)"x-vp-sender-id", (Object)senderId);
        lastSenderId = senderId;
        String vpInstance = (String)httpHeaders.get("x-vp-instance-id");
        log.info("Test producer called with {}: {}", (Object)"x-vp-instance-id", (Object)vpInstance);
        lastVpInstance = vpInstance;
        String orgConsumer = (String)httpHeaders.get("x-rivta-original-serviceconsumer-hsaid");
        log.info("Test producer called with {}: {}", (Object)"x-rivta-original-serviceconsumer-hsaid", (Object)orgConsumer);
        lastOriginalConsumer = orgConsumer;
        return message;
    }

    public static String getLastVpInstance() {
        return lastVpInstance;
    }

    public static String getLastSenderId() {
        return lastSenderId;
    }

    public static String getLastOriginalConsumer() {
        return lastOriginalConsumer;
    }
}

