/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.agp.test.consumer;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;

public abstract class AbstractTestConsumer<ServiceInterface> {
    public static final String SAMPLE_SENDER_ID = "sample-sender-id";
    public static final String SAMPLE_ORIGINAL_CONSUMER_HSAID = "sample-original-consumer-hsaid";
    public static final String SAMPLE_CORRELATION_ID = "sample-correlation-id";
    protected ServiceInterface _service = null;
    private Class<ServiceInterface> _serviceType;

    public AbstractTestConsumer(Class<ServiceInterface> serviceType, String serviceAddress, String senderId, String originalConsumerHsaId, String correlationId) {
        this._serviceType = serviceType;
        JaxWsProxyFactoryBean proxyFactory = new JaxWsProxyFactoryBean();
        proxyFactory.setServiceClass(this.getServiceType());
        proxyFactory.setAddress(serviceAddress);
        SpringBusFactory bf = new SpringBusFactory();
        URL cxfConfig = this.getClass().getClassLoader().getResource("agp-cxf-test-consumer-config.xml");
        if (cxfConfig != null) {
            proxyFactory.setBus(bf.createBus(cxfConfig));
        }
        this._service = proxyFactory.create(this.getServiceType());
        this.setSenderOriginalConsumerCorrelation(this._service, senderId, originalConsumerHsaId, correlationId);
    }

    Class<ServiceInterface> getServiceType() {
        return this._serviceType;
    }

    private void setSenderOriginalConsumerCorrelation(ServiceInterface service, String senderId, String originalConsumerHsaId, String correlationId) {
        Client proxy = ClientProxy.getClient(service);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (senderId != null) {
            headers.put("x-vp-sender-id", Arrays.asList(senderId));
        }
        if (originalConsumerHsaId != null) {
            headers.put("x-rivta-original-serviceconsumer-hsaid", Arrays.asList(originalConsumerHsaId));
        }
        if (correlationId != null) {
            headers.put("x-skltp-correlation-id", Arrays.asList(correlationId));
        }
        proxy.getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
    }
}

