/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.agp.test.producer;

import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.skltp.agp.riv.itintegration.engagementindex.findcontent.v1.rivtabp21.FindContentResponderInterface;
import se.skltp.agp.riv.itintegration.engagementindex.findcontentresponder.v1.FindContentResponseType;
import se.skltp.agp.riv.itintegration.engagementindex.findcontentresponder.v1.FindContentType;
import se.skltp.agp.riv.itintegration.engagementindex.v1.EngagementType;

@WebService(serviceName="FindContentResponderService", portName="FindContentResponderPort", targetNamespace="urn:riv:itintegration:engagementindex:FindContent:1:rivtabp21", name="FindContentInteraction")
public class EngagemangsindexTestProducer
implements FindContentResponderInterface {
    public static final String TEST_ID_FAULT_INVALID_ID_IN_EI = "EI:INV_ID";
    public static final String TEST_ID_FAULT_TIMEOUT_IN_EI = "EI:TIMEOUT";
    private static final Logger log = LoggerFactory.getLogger(EngagemangsindexTestProducer.class);
    private String eiServiceDomain;
    private String eiCategorization;
    private long serviceTimeoutMs;
    private static final Map<String, FindContentResponseType> INDEX = new HashMap<String, FindContentResponseType>();

    public void setEiServiceDomain(String eiServiceDomain) {
        this.eiServiceDomain = eiServiceDomain;
    }

    public void setEiCategorization(String eiCategorization) {
        this.eiCategorization = eiCategorization;
    }

    public void setServiceTimeoutMs(long serviceTimeoutMs) {
        this.serviceTimeoutMs = serviceTimeoutMs;
    }

    public EngagemangsindexTestProducer() {
        if (INDEX.size() == 0) {
            this.initIndex();
        }
    }

    public FindContentResponseType findContent(String logicalAdress, FindContentType request) {
        FindContentResponseType response;
        log.info("### Engagemengsindex.findContent() received a request for Registered Resident id: {}", (Object)request.getRegisteredResidentIdentification());
        String id = request.getRegisteredResidentIdentification();
        if (TEST_ID_FAULT_INVALID_ID_IN_EI.equals(id)) {
            throw new RuntimeException("Invalid Id: " + id);
        }
        if (TEST_ID_FAULT_TIMEOUT_IN_EI.equals(id)) {
            try {
                Thread.sleep(this.serviceTimeoutMs + 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((response = INDEX.get(request.getRegisteredResidentIdentification())) == null) {
            response = new FindContentResponseType();
        }
        log.info("### Engagemengsindex return {} items", (Object)response.getEngagement().size());
        return response;
    }

    private void initIndex() {
        FindContentResponseType response = new FindContentResponseType();
        response.getEngagement().add(this.createResponse("HSA-ID-4", "121212121212", "1002", "20130301000000"));
        response.getEngagement().add(this.createResponse("HSA-ID-5", "121212121212", "1003", "20130401000000"));
        response.getEngagement().add(this.createResponse("HSA-ID-6", "121212121212", "1004", "20130401000000"));
        INDEX.put("121212121212", response);
        log.info("### Engagemengsindex add {} items to the index for resident {}", (Object)response.getEngagement().size(), (Object)"121212121212");
        response = new FindContentResponseType();
        response.getEngagement().add(this.createResponse("HSA-ID-1", "194911172296", "1001", "20130101000000"));
        response.getEngagement().add(this.createResponse("HSA-ID-2", "194911172296", "1001", "20130101000000"));
        INDEX.put("194911172296", response);
        log.info("### Engagemengsindex add {} items to the index for resident {}", (Object)response.getEngagement().size(), (Object)"194911172296");
        response = new FindContentResponseType();
        response.getEngagement().add(this.createResponse("HSA-ID-1", "198611062384", "1002", "20130301000000"));
        response.getEngagement().add(this.createResponse("HSA-ID-2", "198611062384", "1003", "20130401000000"));
        response.getEngagement().add(this.createResponse("HSA-ID-2", "198611062384", "1004", "20130401000000"));
        response.getEngagement().add(this.createResponse("HSA-ID-3", "198611062384", "1004", "20130415000000"));
        INDEX.put("198611062384", response);
        log.info("### Engagemengsindex add {} items to the index for resident {}", (Object)response.getEngagement().size(), (Object)"198611062384");
        response = new FindContentResponseType();
        response.getEngagement().add(this.createResponse("HSA-ID-1", "192011189228", "5001", "20130101000000"));
        INDEX.put("192011189228", response);
        log.info("### Engagemengsindex add {} items to the index for resident {}", (Object)response.getEngagement().size(), (Object)"192011189228");
        response = new FindContentResponseType();
        response.getEngagement().add(this.createResponse("HSA-ID-7", "194804032094", "6001", "20130106000000"));
        INDEX.put("194804032094", response);
        log.info("### Engagemengsindex add {} items to the index for resident {}", (Object)response.getEngagement().size(), (Object)"194804032094");
    }

    private EngagementType createResponse(String receiverLogicalAddress, String registeredResidentIdentification, String businessObjectId, String date) {
        EngagementType e = new EngagementType();
        e.setServiceDomain(this.eiServiceDomain);
        e.setCategorization(this.eiCategorization);
        e.setLogicalAddress(receiverLogicalAddress);
        e.setRegisteredResidentIdentification(registeredResidentIdentification);
        e.setBusinessObjectInstanceIdentifier(businessObjectId);
        e.setCreationTime(date);
        e.setUpdateTime(date);
        e.setMostRecentContent(date);
        e.setSourceSystem(receiverLogicalAddress);
        return e;
    }
}

