/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.agp.test.producer;

import java.util.GregorianCalendar;
import java.util.UUID;
import javax.jws.WebService;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import se.skltp.agp.riv.vagvalsinfo.v2.AnropsBehorighetsInfoType;
import se.skltp.agp.riv.vagvalsinfo.v2.HamtaAllaAnropsBehorigheterResponseType;
import se.skltp.agp.riv.vagvalsinfo.v2.HamtaAllaVirtualiseringarResponseType;
import se.skltp.agp.riv.vagvalsinfo.v2.SokVagvalsInfoInterface;
import se.skltp.agp.riv.vagvalsinfo.v2.VirtualiseringsInfoType;

@WebService(serviceName="SokVagvalsServiceSoap11LitDocService", portName="SokVagvalsSoap11LitDocPort", targetNamespace="urn:skl:tp:vagvalsinfo:v2", endpointInterface="se.skltp.agp.riv.vagvalsinfo.v2.SokVagvalsInfoInterface")
public class TakTestProducer
implements SokVagvalsInfoInterface {
    private static final Logger log = LoggerFactory.getLogger(TakTestProducer.class);
    private static final String TEST_ADDRESS = "TEST_ADDRESS";
    private static final String TEST_RIV_PROFIL = "TEST_RIV_PROFIL";
    private static final String TEST_VIRTUALISERING_INFO = "TEST_VIRTUALISERING_INFO";
    private static final String[] receivers = new String[]{"HSA-ID-1", "HSA-ID-2", "HSA-ID-3", "HSA-ID-4", "HSA-ID-5", "HSA-ID-6"};
    private long serviceTimeout;
    private String targetNamespace;
    private String targetNamespaceAnotherMajorVersion;
    private String targetNamespaceYetAnotherMajorVersion;

    public void log() {
        log.info(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TakTestProducer\n");
        sb.append("targetNamespace:");
        sb.append(this.targetNamespace);
        sb.append("\n");
        sb.append("targetNamespaceAnotherMajorVersion:");
        sb.append(this.targetNamespaceAnotherMajorVersion);
        sb.append("\n");
        sb.append("targetNamespaceYetAnotherMajorVersion:");
        sb.append(this.targetNamespaceYetAnotherMajorVersion);
        sb.append("\n");
        sb.append("serviceTimeout:");
        sb.append(this.serviceTimeout);
        sb.append("\n");
        return sb.toString();
    }

    public void setServiceTimeout(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
        log.info("service timeout is now: " + serviceTimeout);
    }

    public void setTargetNamespace(String n) {
        this.targetNamespace = n;
        if (this.targetNamespace == null || this.targetNamespace.isEmpty()) {
            throw new BeanInitializationException("targetNamespace is mandatory");
        }
        if (!this.targetNamespace.matches("^.+?\\d$")) {
            throw new BeanInitializationException("targetNamespace must end with a numeric");
        }
        try {
            int i = Integer.parseInt(this.targetNamespace.substring(this.targetNamespace.length() - 1));
            if (i < 1) {
                this.targetNamespaceAnotherMajorVersion = this.targetNamespace.substring(0, this.targetNamespace.length() - 1) + "1";
                this.targetNamespaceYetAnotherMajorVersion = this.targetNamespace.substring(0, this.targetNamespace.length() - 1) + "2";
            } else {
                this.targetNamespaceAnotherMajorVersion = this.targetNamespace.substring(0, this.targetNamespace.length() - 1) + (i + 1);
                this.targetNamespaceYetAnotherMajorVersion = this.targetNamespace.substring(0, this.targetNamespace.length() - 1) + (i + 2);
            }
        }
        catch (NumberFormatException nn) {
            throw new BeanInitializationException("targetNamespace last character not numeric? " + nn.getLocalizedMessage());
        }
    }

    public HamtaAllaAnropsBehorigheterResponseType hamtaAllaAnropsBehorigheter(Object parameters) {
        log.info("tak stub received request hamtaAllaAnropsBehorigheter");
        HamtaAllaAnropsBehorigheterResponseType resp = this.createBehorighetStubData();
        log.info("tak stub returning {} AnropsBehorighetsInfo", (Object)resp.getAnropsBehorighetsInfo().size());
        return resp;
    }

    public HamtaAllaVirtualiseringarResponseType hamtaAllaVirtualiseringar(Object parameters) {
        log.info("tak stub received request hamtaAllaVirtualiseringar");
        HamtaAllaVirtualiseringarResponseType result = this.createVirtualiseringStubData();
        log.info("tak stub returning {} VirtualiseringInfo", (Object)result.getVirtualiseringsInfo().size());
        return result;
    }

    protected HamtaAllaVirtualiseringarResponseType createVirtualiseringStubData() {
        HamtaAllaVirtualiseringarResponseType type = new HamtaAllaVirtualiseringarResponseType();
        for (int i = 0; i < 6; ++i) {
            type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(this.targetNamespace, receivers[i]));
        }
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(this.targetNamespace, "HSA-ID-77"));
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-11"));
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-12"));
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(this.targetNamespaceYetAnotherMajorVersion, "HSA-ID-31"));
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(this.targetNamespaceYetAnotherMajorVersion, "HSA-ID-32"));
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(UUID.randomUUID().toString(), "HSA-ID-FEL"));
        type.getVirtualiseringsInfo().add(this.virtualiseringsInfoType(UUID.randomUUID().toString(), "HSA-ID-FEL"));
        return type;
    }

    protected HamtaAllaAnropsBehorigheterResponseType createBehorighetStubData() {
        HamtaAllaAnropsBehorigheterResponseType type = new HamtaAllaAnropsBehorigheterResponseType();
        for (int i = 0; i < 6; ++i) {
            type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespace, receivers[i], "sample-sender-id"));
        }
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespace, "HSA-ID-1", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespace, "HSA-ID-77", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-11", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-12", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-31", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-32", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(this.targetNamespaceAnotherMajorVersion, "HSA-ID-1", "sample-original-consumer-hsaid"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(UUID.randomUUID().toString(), "HSA-ID-FEL", "TK_HSA-ID-FEL"));
        type.getAnropsBehorighetsInfo().add(this.anropsBehorighetsInfoType(UUID.randomUUID().toString(), "HSA-ID-FEL", "TK_HSA-ID-FEL"));
        return type;
    }

    protected VirtualiseringsInfoType virtualiseringsInfoType(String ns, String ls) {
        VirtualiseringsInfoType type = new VirtualiseringsInfoType();
        type.setAdress(TEST_ADDRESS);
        type.setFromTidpunkt(this.xmlDate());
        type.setReceiverId(ls);
        type.setRivProfil(TEST_RIV_PROFIL);
        type.setTjansteKontrakt(ns);
        type.setTomTidpunkt(type.getFromTidpunkt());
        type.setVirtualiseringsInfoId(TEST_VIRTUALISERING_INFO);
        System.out.println("Adress: " + type.getAdress() + ", From: " + type.getFromTidpunkt() + " To: " + type.getTomTidpunkt() + ", ReceiverId: " + type.getReceiverId() + ", RIVprofil: " + type.getRivProfil() + ", Kontrakt: " + type.getTjansteKontrakt());
        return type;
    }

    protected AnropsBehorighetsInfoType anropsBehorighetsInfoType(String ns, String rId, String sId) {
        AnropsBehorighetsInfoType type = new AnropsBehorighetsInfoType();
        type.setTjansteKontrakt(ns);
        type.setReceiverId(rId);
        type.setSenderId(sId);
        type.setFromTidpunkt(this.xmlDate());
        type.setTomTidpunkt(type.getFromTidpunkt());
        return type;
    }

    private XMLGregorianCalendar xmlDate() {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)GregorianCalendar.getInstance());
        }
        catch (Exception err) {
            return null;
        }
    }
}

