/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.agp.test.producer;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestProducerDb {
    private static final Logger log = LoggerFactory.getLogger(TestProducerDb.class);
    public static final String TEST_LOGICAL_ADDRESS_1 = "HSA-ID-1";
    public static final String TEST_LOGICAL_ADDRESS_2 = "HSA-ID-2";
    public static final String TEST_LOGICAL_ADDRESS_3 = "HSA-ID-3";
    public static final String TEST_LOGICAL_ADDRESS_4 = "HSA-ID-4";
    public static final String TEST_LOGICAL_ADDRESS_5 = "HSA-ID-5";
    public static final String TEST_LOGICAL_ADDRESS_6 = "HSA-ID-6";
    public static final String TEST_LOGICAL_ADDRESS_7 = "HSA-ID-7";
    public static final String TEST_RR_ID_MANY_HITS_NO_ERRORS = "121212121212";
    public static final String TEST_RR_ID_ZERO_HITS = "188803099368";
    public static final String TEST_RR_ID_ONE_HIT = "194911172296";
    public static final String TEST_RR_ID_MANY_HITS = "198611062384";
    public static final String TEST_RR_ID_FAULT_INVALID_ID = "192011189228";
    public static final String TEST_RR_ID_EJ_SAMVERKAN_I_TAK = "194804032094";
    public static final String TEST_BO_ID_ONE_HIT = "1001";
    public static final String TEST_BO_ID_MANY_HITS_1 = "1002";
    public static final String TEST_BO_ID_MANY_HITS_2 = "1003";
    public static final String TEST_BO_ID_MANY_HITS_3 = "1004";
    public static final String TEST_BO_ID_MANY_HITS_4 = "1004";
    public static final String TEST_BO_ID_MANY_HITS_NEW_1 = "2001";
    public static final String TEST_BO_ID_FAULT_INVALID_ID = "5001";
    public static final String TEST_BO_ID_EJ_SAMVERKAN_I_TAK = "6001";
    public static final String TEST_DATE_ONE_HIT = "20130101000000";
    public static final String TEST_DATE_MANY_HITS_1 = "20130301000000";
    public static final String TEST_DATE_MANY_HITS_2 = "20130401000000";
    public static final String TEST_DATE_MANY_HITS_3 = "20130401000000";
    public static final String TEST_DATE_MANY_HITS_4 = "20130415000000";
    public static final String TEST_DATE_FAULT_INVALID_ID = "20130101000000";
    public static final String TEST_DATE_EJ_SAMVERKAN_I_TAK = "20130106000000";
    private long serviceTimeoutMs;
    private static Map<String, Object> DB = null;

    public void setServiceTimeoutMs(long serviceTimeoutMs) {
        this.serviceTimeoutMs = serviceTimeoutMs;
    }

    public TestProducerDb() {
        this.initDb();
    }

    public Object processRequest(String logicalAddress, String registeredResidentId) {
        if (TEST_RR_ID_FAULT_INVALID_ID.equals(registeredResidentId)) {
            throw new RuntimeException("Invalid Id: " + registeredResidentId);
        }
        if (TEST_RR_ID_EJ_SAMVERKAN_I_TAK.equals(registeredResidentId)) {
            throw new RuntimeException("VP007 Authorization missing");
        }
        this.doSomeProcessingForSomeTime(logicalAddress);
        Object object = this.retrieveFromDb(logicalAddress, registeredResidentId);
        return object;
    }

    private void doSomeProcessingForSomeTime(String logicalAddress) {
        long processingTime = this.getProcessingTime(logicalAddress);
        try {
            log.debug("## SLEEP FOR " + processingTime + " ms.");
            Thread.sleep(processingTime);
            log.debug("## SLEEP DONE.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getProcessingTime(String logicalAddress) {
        long processingTime = 0L;
        processingTime = TEST_LOGICAL_ADDRESS_1.equals(logicalAddress) ? 1000L : (TEST_LOGICAL_ADDRESS_2.equals(logicalAddress) ? this.serviceTimeoutMs - 1000L : (TEST_LOGICAL_ADDRESS_3.equals(logicalAddress) ? this.serviceTimeoutMs + 1000L : 500L));
        return processingTime;
    }

    public abstract Object createResponse(Object ... var1);

    public abstract Object createResponseItem(String var1, String var2, String var3, String var4);

    void initDb() {
        log.debug("### INIT-DB CALLED, DB == NULL? " + (DB == null));
        this.resetDb();
        Object response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_4, TEST_RR_ID_MANY_HITS_NO_ERRORS, TEST_BO_ID_MANY_HITS_1, TEST_DATE_MANY_HITS_1));
        this.storeInDb(TEST_LOGICAL_ADDRESS_4, TEST_RR_ID_MANY_HITS_NO_ERRORS, response);
        response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_5, TEST_RR_ID_MANY_HITS_NO_ERRORS, TEST_BO_ID_MANY_HITS_2, "20130401000000"));
        this.storeInDb(TEST_LOGICAL_ADDRESS_5, TEST_RR_ID_MANY_HITS_NO_ERRORS, response);
        response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_6, TEST_RR_ID_MANY_HITS_NO_ERRORS, "1004", "20130401000000"));
        this.storeInDb(TEST_LOGICAL_ADDRESS_6, TEST_RR_ID_MANY_HITS_NO_ERRORS, response);
        response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_1, TEST_RR_ID_ONE_HIT, TEST_BO_ID_ONE_HIT, "20130101000000"));
        this.storeInDb(TEST_LOGICAL_ADDRESS_1, TEST_RR_ID_ONE_HIT, response);
        response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_1, TEST_RR_ID_MANY_HITS, TEST_BO_ID_MANY_HITS_1, TEST_DATE_MANY_HITS_1));
        this.storeInDb(TEST_LOGICAL_ADDRESS_1, TEST_RR_ID_MANY_HITS, response);
        response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_2, TEST_RR_ID_MANY_HITS, TEST_BO_ID_MANY_HITS_2, "20130401000000"), this.createResponseItem(TEST_LOGICAL_ADDRESS_2, TEST_RR_ID_MANY_HITS, "1004", "20130401000000"));
        this.storeInDb(TEST_LOGICAL_ADDRESS_2, TEST_RR_ID_MANY_HITS, response);
        response = this.createResponse(this.createResponseItem(TEST_LOGICAL_ADDRESS_3, TEST_RR_ID_MANY_HITS, "1004", TEST_DATE_MANY_HITS_4));
        this.storeInDb(TEST_LOGICAL_ADDRESS_3, TEST_RR_ID_MANY_HITS, response);
    }

    public void resetDb() {
        DB = new HashMap<String, Object>();
    }

    public void refreshDb() {
        this.initDb();
    }

    public void storeInDb(String logicalAddress, String registeredResidentId, Object value) {
        DB.put(logicalAddress + "|" + registeredResidentId, value);
    }

    public Object retrieveFromDb(String logicalAddress, String registeredResidentId) {
        return DB.get(logicalAddress + "|" + registeredResidentId);
    }
}

