/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.commons.log;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.mule.api.MuleContext;
import org.mule.transport.jms.JmsConnector;
import org.soitoolkit.commons.mule.log.DefaultEventLogger;
import org.soitoolkit.commons.mule.util.MuleUtil;

public class ExtensibleEventLogger
extends DefaultEventLogger {
    protected MuleContext muleContext = null;

    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        this.muleContext = muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(String queue, String msg) {
        try {
            Session s = null;
            try {
                s = this.getSession();
                this.sendOneTextMessage(s, queue, msg);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private Session getSession() throws JMSException {
        JmsConnector jmsConn = (JmsConnector)MuleUtil.getSpringBean((MuleContext)this.muleContext, (String)"soitoolkit-jms-connector");
        Connection c = jmsConn.getConnection();
        Session s = c.createSession(false, 1);
        return s;
    }

    private void sendOneTextMessage(Session session, String queueName, String message) {
        MessageProducer publisher = null;
        try {
            publisher = session.createProducer((Destination)session.createQueue(queueName));
            TextMessage textMessage = session.createTextMessage(message);
            publisher.send((Message)textMessage);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (publisher != null) {
                    publisher.close();
                }
            }
            catch (JMSException e) {}
        }
    }
}

