/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.commons.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.skltp.commons.log.ExtensibleEventLogger;

public class TpDefaultEventLogger
extends ExtensibleEventLogger {
    private static final Logger log = LoggerFactory.getLogger(TpDefaultEventLogger.class);
    private boolean doLogToJms = true;
    private String jmsInfoEventQueue = "SOITOOLKIT.LOG.INFO";
    private String jmsErrorEventQueue = "SOITOOLKIT.LOG.ERROR";

    public void setDoLogToJms(boolean doLogToJms) {
        log.debug("setting doLogToJms: {}", (Object)doLogToJms);
        this.doLogToJms = doLogToJms;
    }

    public void setJmsInfoEventQueue(String jmsInfoEventQueue) {
        log.debug("setting jmsInfoEventQueue: {}", (Object)jmsInfoEventQueue);
        this.jmsInfoEventQueue = jmsInfoEventQueue;
    }

    public void setJmsErrorEventQueue(String jmsErrorEventQueue) {
        log.debug("setting jmsErrorEventQueue: {}", (Object)jmsErrorEventQueue);
        this.jmsErrorEventQueue = jmsErrorEventQueue;
    }

    protected void dispatchInfoEvent(String msg) {
        log.debug("dispatchInfoEvent: doLogToJms: {}, jmsInfoEventQueue: {}", (Object)this.doLogToJms, (Object)this.jmsInfoEventQueue);
        if (this.doLogToJms) {
            this.dispatchEvent(this.jmsInfoEventQueue, msg);
        }
    }

    protected void dispatchErrorEvent(String msg) {
        log.debug("dispatchErrorEvent: doLogToJms: {}, jmsErrorEventQueue: {}", (Object)this.doLogToJms, (Object)this.jmsErrorEventQueue);
        if (this.doLogToJms) {
            this.dispatchEvent(this.jmsErrorEventQueue, msg);
        }
    }
}

