/*
 * Decompiled with CFR 0.152.
 */
package se.skltp.patch.cxfrtbindingssoap.mule.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import se.skltp.patch.cxfrtbindingssoap.mule.common.FileHelper;

public class MuleCxfSoapActionBaseIntegrationTest
extends FunctionalTestCase {
    protected static final String REQUEST_FILE = "ping-soap-request.xml";
    protected static final String RESPONSE_TEST_STRING = "Ping response from test producer";
    protected static final String URL_TEST_PRODUCER = "http://localhost:8081/ping/1/rivtabp20";
    protected static final String SOAP_ACTION_SAME_AS_IN_WSDL = "\"urn:riv:test:PingResponder:1:ping\"";
    protected static final String SOAP_ACTION_EMPTY = "";
    protected static final String SOAP_ACTION_COMPLETELY_WRONG = "\"urn:this:is:not:a:valid:soapAction\"";
    protected MuleClient muleClient;
    protected HashMap<String, String> requestMsgProps;

    protected String getConfigResources() {
        return "tp2-service-mule-descriptor.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = new MuleClient(muleContext);
        this.requestMsgProps = new HashMap();
        this.requestMsgProps.put("Content-Type", "text/xml");
        this.requestMsgProps.put("http.method", "POST");
    }

    @Ignore(value="run in subclass only")
    @Test
    public void testSoapAction_sameAsInWsdl() throws Exception {
        this.setSoapAction(SOAP_ACTION_SAME_AS_IN_WSDL);
        this.verifyOkResponse(this.callService());
    }

    @Ignore(value="run in subclass only")
    @Test
    public void testSoapAction_empty() throws Exception {
        this.setSoapAction(SOAP_ACTION_EMPTY);
        this.verifyOkResponse(this.callService());
    }

    @Ignore(value="run in subclass only")
    @Test
    public void testSoapAction_completelyWrong() throws Exception {
        this.setSoapAction(SOAP_ACTION_COMPLETELY_WRONG);
        this.verifyOkResponse(this.callService());
    }

    protected void setSoapAction(String soapAction) {
        this.requestMsgProps.put("SOAPAction", soapAction);
    }

    protected MuleMessage callService() throws Exception {
        int timeout = 3000;
        String payload = FileHelper.getFileFromClasspath(REQUEST_FILE);
        MuleMessage responseMsg = this.muleClient.send(URL_TEST_PRODUCER, (Object)payload, this.requestMsgProps, timeout);
        return responseMsg;
    }

    protected void verifyOkResponse(MuleMessage responseMsg) throws IOException {
        Assert.assertEquals((Object)"200", (Object)responseMsg.getInboundProperty("http.status"));
        String response = this.getPayloadAsString(responseMsg);
        Assert.assertTrue((boolean)response.contains(RESPONSE_TEST_STRING));
    }

    protected void verifyHttp500Response(MuleMessage responseMsg) throws IOException {
        Assert.assertEquals((Object)"500", (Object)responseMsg.getInboundProperty("http.status"));
    }

    protected String getPayloadAsString(MuleMessage message) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)((InputStream)message.getPayload()), (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }
}

