/*
 * Decompiled with CFR 0.152.
 */
package se.sundsvall.dept44.maven.enforcer.rule;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class Dept44RequiredPropertiesRule
implements EnforcerRule {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String DOCKER_IMAGE_NAME_REGEX = "^ms-[a-z0-9-]+$";
    private static final String PROPERTY_FILE_PATTERN = "^application(-\\w+)?(.yaml|.yml|.properties)$";
    private static final String YAML_FILE_EXTENSION_PATTERN = ".*(.yaml|.yml)$";
    private boolean requireDockerImageName = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            String resourcesDir = (String)helper.evaluate("${project.basedir}/src/main/resources");
            if ("pom".equalsIgnoreCase(project.getPackaging())) {
                return;
            }
            List<String> errors = this.ensureDockerImageNameMeetsRequirements(project);
            errors.addAll(this.ensureOpenApiPropertiesAreSet(resourcesDir));
            if (!errors.isEmpty()) {
                String errorsString = errors.stream().collect(Collectors.joining(System.lineSeparator() + " - ", " - ", System.lineSeparator()));
                throw new EnforcerRuleException(System.lineSeparator() + errorsString);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private List<String> ensureDockerImageNameMeetsRequirements(MavenProject project) {
        ArrayList<String> errors = new ArrayList<String>();
        String dockerImageName = project.getProperties().getProperty("docker.image.name", "");
        if (this.requireDockerImageName && StringUtils.isBlank((CharSequence)dockerImageName)) {
            errors.add("Required build property \"docker.image.name\" is missing or empty");
        }
        if (!"".equals(dockerImageName) && !dockerImageName.matches(DOCKER_IMAGE_NAME_REGEX)) {
            errors.add("Build property \"docker.image.name\" must match regex \"^ms-[a-z0-9-]+$\", e.g. \"ms-service-123\"");
        }
        return errors;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private List<String> ensureOpenApiPropertiesAreSet(String resourcesDir) throws EnforcerRuleException {
        boolean openApiEnabled = true;
        boolean openApiNamePropertySet = false;
        boolean openApiTitlePropertySet = false;
        boolean openApiVersionPropertySet = false;
        File[] propertyFiles = new File(resourcesDir).listFiles((dir, name) -> name.matches(PROPERTY_FILE_PATTERN));
        if (propertyFiles == null || propertyFiles.length == 0) {
            throw new EnforcerRuleException("No application properties/YAML files exist");
        }
        for (File propertyFile : propertyFiles) {
            Properties properties;
            block16: {
                properties = new Properties();
                try {
                    if (propertyFile.getName().matches(YAML_FILE_EXTENSION_PATTERN)) {
                        Map props = (Map)OBJECT_MAPPER.readValue(propertyFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        properties.putAll(this.flatten(props));
                        break block16;
                    }
                    try (FileInputStream in = new FileInputStream(propertyFile);){
                        properties.load(in);
                    }
                }
                catch (IOException e) {
                    throw new EnforcerRuleException("Unable to load properties/YAML file " + propertyFile.getName(), (Exception)e);
                }
            }
            openApiEnabled = Optional.ofNullable(properties.getOrDefault((Object)"openapi.enabled", "true")).map(Object::toString).map(Boolean::valueOf).orElse(true);
            if (!openApiEnabled) break;
            if (Optional.ofNullable(properties.get("openapi.name")).isPresent()) {
                openApiNamePropertySet = true;
            }
            if (Optional.ofNullable(properties.get("openapi.title")).isPresent()) {
                openApiTitlePropertySet = true;
            }
            if (!Optional.ofNullable(properties.get("openapi.version")).isPresent()) continue;
            openApiVersionPropertySet = true;
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (openApiEnabled) {
            if (!openApiNamePropertySet) {
                errors.add("Property \"openapi.name\" is missing or empty in application properties/YAML");
            }
            if (!openApiTitlePropertySet) {
                errors.add("Property \"openapi.title\" is missing or empty in application*.properties/YAML");
            }
            if (!openApiVersionPropertySet) {
                errors.add("Property \"openapi.version\" is missing or empty in application*.properties/YAML");
            }
        }
        return errors;
    }

    public String getCacheId() {
        return UUID.randomUUID().toString();
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(@Nonnull EnforcerRule rule) {
        return false;
    }

    public void setRequireDockerImageName(boolean requireDockerImageName) {
        this.requireDockerImageName = requireDockerImageName;
    }

    private Map<String, Object> flatten(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(entry -> this.flatten((Map.Entry<String, Object>)entry).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Object> flatten(Map.Entry<String, Object> entry) {
        if (!(entry.getValue() instanceof Map)) {
            return Map.of(entry.getKey(), entry.getValue());
        }
        String prefix = entry.getKey();
        Map values = (Map)entry.getValue();
        HashMap<String, Object> flattenMap = new HashMap<String, Object>();
        values.keySet().forEach(key -> flattenMap.put(prefix + "." + key, values.get(key)));
        return this.flatten(flattenMap);
    }
}

