/*
 * Decompiled with CFR 0.152.
 */
package se.sundsvall.dept44.common.validators.annotation.impl;

import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.ReflectionUtils;
import se.sundsvall.dept44.common.validators.annotation.ValidBase64;
import se.sundsvall.dept44.common.validators.annotation.impl.AbstractValidator;

public class ValidBase64ConstraintValidator
extends AbstractValidator
implements ConstraintValidator<ValidBase64, String> {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private boolean nullable;

    public void initialize(ValidBase64 constraintAnnotation) {
        this.nullable = constraintAnnotation.nullable();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value) && this.nullable) {
            return true;
        }
        return this.isValidBase64(value);
    }

    @Override
    public boolean isValid(String value) {
        return this.isValid(value, null);
    }

    @Override
    public String getMessage() {
        return Optional.ofNullable(ReflectionUtils.findMethod(ValidBase64.class, (String)"message")).map(Method::getDefaultValue).map(Object::toString).orElseThrow(ValidBase64ConstraintValidator.createException(ValidBase64.class.getName()));
    }

    private boolean isValidBase64(String value) {
        try {
            BASE64_DECODER.decode(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

