/*
 * Decompiled with CFR 0.152.
 */
package se.sundsvall.dept44.common.validators.annotation.impl;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.ReflectionUtils;
import se.sundsvall.dept44.common.validators.annotation.ValidMSISDN;
import se.sundsvall.dept44.common.validators.annotation.impl.AbstractValidator;

public class ValidMSISDNConstraintValidator
extends AbstractValidator
implements ConstraintValidator<ValidMSISDN, String> {
    private static final String REGEX_PATTERN = "^\\+[1-9]{1}[0-9]{3,14}$";
    private boolean nullable;

    public void initialize(ValidMSISDN constraintAnnotation) {
        this.nullable = constraintAnnotation.nullable();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value) && this.nullable) {
            return true;
        }
        return Objects.nonNull(value) && value.matches(REGEX_PATTERN);
    }

    @Override
    public boolean isValid(String value) {
        return this.isValid(value, null);
    }

    @Override
    public String getMessage() {
        return Optional.ofNullable(ReflectionUtils.findMethod(ValidMSISDN.class, (String)"message")).map(Method::getDefaultValue).map(Object::toString).orElseThrow(ValidMSISDNConstraintValidator.createException(ValidMSISDN.class.getName()));
    }
}

