/*
 * Decompiled with CFR 0.152.
 */
package se.sundsvall.dept44.common.validators.annotation.impl;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.ReflectionUtils;
import se.sundsvall.dept44.common.validators.annotation.ValidOrganizationNumber;
import se.sundsvall.dept44.common.validators.annotation.impl.AbstractValidator;

public class ValidOrganizationNumberConstraintValidator
extends AbstractValidator
implements ConstraintValidator<ValidOrganizationNumber, String> {
    private static final String REGEX_PATTERN = "^([1235789][\\d][2-9]\\d{7})$";
    private boolean nullable;

    public void initialize(ValidOrganizationNumber constraintAnnotation) {
        this.nullable = constraintAnnotation.nullable();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value) && this.nullable) {
            return true;
        }
        return Objects.nonNull(value) && value.matches(REGEX_PATTERN);
    }

    @Override
    public boolean isValid(String value) {
        return this.isValid(value, null);
    }

    @Override
    public String getMessage() {
        return Optional.ofNullable(ReflectionUtils.findMethod(ValidOrganizationNumber.class, (String)"message")).map(Method::getDefaultValue).map(Object::toString).orElseThrow(ValidOrganizationNumberConstraintValidator.createException(ValidOrganizationNumber.class.getName()));
    }
}

