/*
 * Decompiled with CFR 0.152.
 */
package se.sundsvall.dept44.common.validators.annotation.impl;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.ReflectionUtils;
import se.sundsvall.dept44.common.validators.annotation.ValidUuid;
import se.sundsvall.dept44.common.validators.annotation.impl.AbstractValidator;

public class ValidUuidConstraintValidator
extends AbstractValidator
implements ConstraintValidator<ValidUuid, String> {
    private boolean nullable;

    public void initialize(ValidUuid constraintAnnotation) {
        this.nullable = constraintAnnotation.nullable();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value) && this.nullable) {
            return true;
        }
        return this.isValidUUID(value);
    }

    @Override
    public boolean isValid(String value) {
        return this.isValid(value, null);
    }

    @Override
    public String getMessage() {
        return Optional.ofNullable(ReflectionUtils.findMethod(ValidUuid.class, (String)"message")).map(Method::getDefaultValue).map(Object::toString).orElseThrow(ValidUuidConstraintValidator.createException(ValidUuid.class.getName()));
    }

    private boolean isValidUUID(String value) {
        try {
            UUID.fromString(String.valueOf(value));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

