/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.springframework.core.io.Resource;
import se.swedenconnect.security.credential.PkiCredential;
import se.swedenconnect.security.credential.factory.X509CertificateFactoryBean;

public abstract class AbstractPkiCredential
implements PkiCredential {
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private PublicKey publicKey;
    private String name;

    @Override
    public PublicKey getPublicKey() {
        return this.certificate != null ? this.certificate.getPublicKey() : this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        if (this.certificate != null) {
            throw new IllegalArgumentException("Cannot assign public key - certificate has already been assigned");
        }
        this.publicKey = publicKey;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        if (this.publicKey != null) {
            throw new IllegalArgumentException("Cannot assign certificate - public key has already been assigned");
        }
        this.certificate = certificate;
    }

    public void setCertificate(Resource certificateResource) throws CertificateException {
        if (this.publicKey != null) {
            throw new IllegalArgumentException("Cannot assign certificate - public key has already been assigned");
        }
        try {
            X509CertificateFactoryBean factory = new X509CertificateFactoryBean(certificateResource);
            factory.afterPropertiesSet();
            this.certificate = (X509Certificate)factory.getObject();
        }
        catch (Exception e) {
            if (e instanceof CertificateException) {
                throw (CertificateException)e;
            }
            throw new IllegalArgumentException("Failed to read certificate resource", e);
        }
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    protected abstract String getDefaultName();

    public void setName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getPublicKey() == null) {
            throw new IllegalArgumentException("Either 'certificate' or 'publicKey' must be assigned");
        }
        if (this.privateKey == null) {
            throw new IllegalArgumentException("Property 'privateKey' must be assigned");
        }
    }

    public void destroy() throws Exception {
    }
}

