/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import org.springframework.core.io.Resource;
import se.swedenconnect.security.credential.AbstractPkiCredential;

public class BasicCredential
extends AbstractPkiCredential {
    public BasicCredential() {
    }

    public BasicCredential(PublicKey publicKey, PrivateKey privateKey) {
        this.setPublicKey(publicKey);
        this.setPrivateKey(privateKey);
    }

    public BasicCredential(X509Certificate certificate, PrivateKey privateKey) {
        this.setCertificate(certificate);
        this.setPrivateKey(privateKey);
    }

    public BasicCredential(Resource certificateResource, PrivateKey privateKey) throws CertificateException {
        this.setCertificate(certificateResource);
        this.setPrivateKey(privateKey);
    }

    @Override
    protected String getDefaultName() {
        X509Certificate cert = this.getCertificate();
        if (cert != null) {
            return cert.getSubjectX500Principal().getName();
        }
        PublicKey key = this.getPublicKey();
        if (key != null) {
            return String.format("%s-%s", key.getAlgorithm(), UUID.randomUUID());
        }
        return "BasicCredential-" + UUID.randomUUID().toString();
    }
}

