/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import se.swedenconnect.security.credential.AbstractReloadablePkiCredential;
import se.swedenconnect.security.credential.factory.KeyStoreFactoryBean;
import se.swedenconnect.security.credential.monitoring.DefaultCredentialTestFunction;

public class KeyStoreCredential
extends AbstractReloadablePkiCredential {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreCredential.class);
    private KeyStoreFactoryBean keyStoreFactory = null;
    private char[] password;
    private KeyStore keyStore;
    private String alias;
    private char[] keyPassword;
    private boolean loaded = false;

    public KeyStoreCredential() {
    }

    public KeyStoreCredential(KeyStore keyStore, String alias, char[] keyPassword) {
        this.setKeyStore(keyStore);
        this.setAlias(alias);
        this.setKeyPassword(keyPassword);
    }

    public KeyStoreCredential(Resource resource, char[] password, String alias, char[] keyPassword) {
        this(resource, KeyStore.getDefaultType(), null, password, alias, keyPassword);
    }

    public KeyStoreCredential(Resource resource, String type, char[] password, String alias, char[] keyPassword) {
        this(resource, type, null, password, alias, keyPassword);
    }

    public KeyStoreCredential(Resource resource, String type, String provider, char[] password, String alias, char[] keyPassword) {
        this.setResource(resource);
        this.setType(type);
        this.setProvider(provider);
        this.setPassword(password);
        this.setAlias(alias);
        this.setKeyPassword(keyPassword);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.load();
    }

    @Override
    public void destroy() {
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
        if (this.keyPassword != null) {
            Arrays.fill(this.keyPassword, '\u0000');
        }
    }

    private synchronized void load() throws Exception {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.keyStore == null) {
            if (this.keyStoreFactory == null) {
                throw new IllegalArgumentException("Missing parameters for creating KeyStore");
            }
            this.keyStoreFactory.afterPropertiesSet();
            this.keyStore = (KeyStore)this.keyStoreFactory.getObject();
            if ("PKCS11".equals(this.keyStore.getType()) && this.getTestFunction() == null) {
                DefaultCredentialTestFunction testFunction = new DefaultCredentialTestFunction();
                testFunction.setProvider(Optional.ofNullable(this.keyStore.getProvider()).map(Provider::getName).orElse(null));
                this.setTestFunction(testFunction);
            }
        }
        this.loadPrivateKey();
        if (super.getCertificate() == null) {
            Assert.hasText((String)this.alias, (String)"Property 'alias' must be set");
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(this.alias);
            if (cert == null) {
                throw new CertificateException("No certificate found at entry " + this.alias);
            }
            this.setCertificate(cert);
            log.debug("Certificate loaded from entry '{}'", (Object)this.alias);
        }
    }

    private synchronized void loadPrivateKey() throws Exception {
        Key key;
        Assert.hasText((String)this.alias, (String)"Property 'alias' must be set");
        if (this.keyPassword == null) {
            if (this.password != null) {
                log.debug("No key password assigned, assuming same password as for keystore ...");
                this.keyPassword = this.password;
            } else {
                throw new IllegalArgumentException("No key password assigned");
            }
        }
        if (!PrivateKey.class.isInstance(key = this.keyStore.getKey(this.alias, this.keyPassword))) {
            throw new KeyStoreException("No private key found at entry " + this.alias);
        }
        super.setPrivateKey((PrivateKey)PrivateKey.class.cast(key));
        log.trace("Private key loaded from entry '{}'", (Object)this.alias);
    }

    public void setResource(Resource resource) {
        if (this.keyStoreFactory == null) {
            this.keyStoreFactory = new KeyStoreFactoryBean();
        }
        this.keyStoreFactory.setResource(resource);
    }

    public void setType(String type) {
        if (this.keyStoreFactory == null) {
            this.keyStoreFactory = new KeyStoreFactoryBean();
        }
        this.keyStoreFactory.setType(type);
    }

    public void setProvider(String provider) {
        if (this.keyStoreFactory == null) {
            this.keyStoreFactory = new KeyStoreFactoryBean();
        }
        this.keyStoreFactory.setProvider(provider);
    }

    public void setPkcs11Configuration(String pkcs11Configuration) {
        if (this.keyStoreFactory == null) {
            this.keyStoreFactory = new KeyStoreFactoryBean();
        }
        this.keyStoreFactory.setPkcs11Configuration(pkcs11Configuration);
    }

    public void setPassword(char[] password) {
        if (this.keyStoreFactory == null) {
            this.keyStoreFactory = new KeyStoreFactoryBean();
        }
        this.keyStoreFactory.setPassword(password);
        this.password = Optional.ofNullable(password).map(p -> Arrays.copyOf(p, ((char[])p).length)).orElse(null);
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = Optional.ofNullable(keyPassword).map(p -> Arrays.copyOf(p, ((char[])p).length)).orElse(null);
    }

    @Override
    public PublicKey getPublicKey() {
        X509Certificate cert = this.getCertificate();
        return cert != null ? cert.getPublicKey() : null;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        throw new IllegalArgumentException("Assigning the public key for a KeyStoreCredential is not allowed");
    }

    @Override
    public synchronized X509Certificate getCertificate() {
        if (!this.loaded) {
            log.warn("KeyStoreCredential '{}' has not been loaded ...", (Object)this.getName());
            try {
                this.load();
            }
            catch (Exception e) {
                log.error("Failed to load KeyStoreCredential '{}'", (Object)this.getName(), (Object)e);
                throw new SecurityException("Failed to load KeyStoreCredential - " + e.getMessage(), e);
            }
        }
        return super.getCertificate();
    }

    @Override
    public synchronized PrivateKey getPrivateKey() {
        if (!this.loaded) {
            log.warn("KeyStoreCredential '{}' has not been loaded ...", (Object)this.getName());
            try {
                this.load();
            }
            catch (Exception e) {
                log.error("Failed to load KeyStoreCredential '{}'", (Object)this.getName(), (Object)e);
                throw new SecurityException("Failed to load KeyStoreCredential - " + e.getMessage(), e);
            }
        }
        return super.getPrivateKey();
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        throw new IllegalArgumentException("Assigning the private key for a KeyStoreCredential is not allowed");
    }

    @Override
    public synchronized void reload() throws Exception {
        if (this.keyStore == null) {
            throw new SecurityException("Error in reload - KeyStoreCredential has not been initialized yet");
        }
        if ("PKCS11".equalsIgnoreCase(this.keyStore.getType())) {
            try {
                log.trace("Reloading private key of credential '{}' ...", (Object)this.getName());
                this.keyStore.load(null, this.password);
                this.loadPrivateKey();
                log.trace("Reloading private key of credential '{}' successful", (Object)this.getName());
            }
            catch (Exception e) {
                log.trace("Failed to reload private key - {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
    }

    @Override
    protected String getDefaultName() {
        if (this.alias != null) {
            String type = Optional.ofNullable(this.keyStore).map(KeyStore::getType).orElse(Optional.ofNullable(this.keyStoreFactory).map(KeyStoreFactoryBean::getType).orElse(null));
            if ("PKCS11".equalsIgnoreCase(type)) {
                String provider = Optional.ofNullable(this.keyStore).map(KeyStore::getProvider).map(Provider::getName).orElse(null);
                if (provider == null) {
                    provider = Optional.ofNullable(this.keyStoreFactory).map(KeyStoreFactoryBean::getProvider).orElse(null);
                }
                if (provider != null) {
                    return provider + "-" + this.alias;
                }
            }
            return this.alias;
        }
        return "KeyStoreCredential-" + UUID.randomUUID().toString();
    }
}

