/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential;

import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import se.swedenconnect.security.credential.AbstractReloadablePkiCredential;
import se.swedenconnect.security.credential.PkiCredential;
import se.swedenconnect.security.credential.monitoring.DefaultCredentialTestFunction;
import se.swedenconnect.security.credential.pkcs11conf.DefaultPkcs11Configuration;
import se.swedenconnect.security.credential.pkcs11conf.Pkcs11Configuration;
import se.swedenconnect.security.credential.pkcs11conf.Pkcs11ConfigurationException;

public class Pkcs11Credential
extends AbstractReloadablePkiCredential {
    private static final Logger log = LoggerFactory.getLogger(Pkcs11Credential.class);
    private Pkcs11Configuration configuration;
    private String alias;
    private char[] pin;
    private boolean loaded = false;

    public Pkcs11Credential() {
    }

    public Pkcs11Credential(Pkcs11Configuration configuration, String alias, char[] pin) throws IllegalArgumentException, SecurityException {
        this(configuration, alias, pin, null);
    }

    public Pkcs11Credential(Pkcs11Configuration configuration, String alias, char[] pin, X509Certificate certificate) {
        this.setConfiguration(configuration);
        this.setAlias(alias);
        this.setPin(pin);
        this.setCertificate(certificate);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.configuration, (String)"'configuration' must not be null");
        Assert.hasText((String)this.alias, (String)"'alias' must be set");
        Assert.notNull((Object)this.pin, (String)"'pin' must not be null");
        this.load();
    }

    @Override
    public void destroy() {
        if (this.pin != null) {
            Arrays.fill(this.pin, '\u0000');
        }
    }

    private synchronized void load() throws IllegalArgumentException, SecurityException {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        PrivateKey pk = null;
        X509Certificate cert = super.getCertificate();
        if (cert != null) {
            pk = this.configuration.getPrivateKeyProvider().get(this.configuration.getProvider(), this.alias, this.pin);
        } else {
            PkiCredential cred = this.configuration.getCredentialProvider().get(this.configuration.getProvider(), this.alias, this.pin);
            if (cred != null) {
                pk = cred.getPrivateKey();
                cert = cred.getCertificate();
            }
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("No private key found under alias '%s'", this.alias));
        }
        if (cert == null) {
            throw new IllegalArgumentException(String.format("No certificate supplied and none found under alias '%s'", this.alias));
        }
        super.setPrivateKey(pk);
        this.setCertificate(cert);
        if (this.getTestFunction() == null) {
            DefaultCredentialTestFunction testFunction = new DefaultCredentialTestFunction();
            testFunction.setProvider(this.configuration.getProvider().getName());
            this.setTestFunction(testFunction);
        }
    }

    @Override
    public synchronized PrivateKey getPrivateKey() {
        if (!this.loaded) {
            log.warn("Pkcs11Credential '{}' has not been loaded ...", (Object)this.getName());
            try {
                this.load();
            }
            catch (Exception e) {
                log.error("Failed to load Pkcs11Credential '{}'", (Object)this.getName(), (Object)e);
                throw new SecurityException("Failed to load Pkcs11Credential - " + e.getMessage(), e);
            }
        }
        return super.getPrivateKey();
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        throw new IllegalArgumentException("Assigning the private key for a Pkcs11Credential is not allowed");
    }

    @Override
    public PublicKey getPublicKey() {
        return Optional.ofNullable(this.getCertificate()).map(Certificate::getPublicKey).orElse(super.getPublicKey());
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        throw new IllegalArgumentException("Assigning the public key for a Pkcs11Credential is not allowed");
    }

    @Override
    public synchronized X509Certificate getCertificate() {
        if (!this.loaded) {
            log.warn("Pkcs11Credential '{}' has not been loaded ...", (Object)this.getName());
            try {
                this.load();
            }
            catch (Exception e) {
                log.error("Failed to load Pkcs11Credential '{}'", (Object)this.getName(), (Object)e);
                throw new SecurityException("Failed to load Pkcs11Credential - " + e.getMessage(), e);
            }
        }
        return super.getCertificate();
    }

    public void setConfiguration(Pkcs11Configuration configuration) {
        this.configuration = configuration;
    }

    public void setConfigurationFile(String configurationFile) throws Pkcs11ConfigurationException {
        DefaultPkcs11Configuration conf = new DefaultPkcs11Configuration(configurationFile);
        conf.afterPropertiesSet();
        this.configuration = conf;
    }

    public void setAlias(String alias) {
        this.alias = Optional.ofNullable(alias).map(a -> a.trim()).orElse(null);
    }

    public void setPin(char[] pin) {
        this.pin = Optional.ofNullable(pin).map(p -> Arrays.copyOf(p, ((char[])p).length)).orElse(null);
    }

    @Override
    public synchronized void reload() throws Exception {
        if (this.configuration == null || this.alias == null || this.pin == null) {
            throw new SecurityException("Error in reload - Pkcs11Credential has not been initialized yet");
        }
        log.trace("Reloading private key under alias '{}' for provider '{}' ...", (Object)this.alias, (Object)this.configuration.getProvider().getName());
        PrivateKey pk = this.configuration.getPrivateKeyProvider().get(this.configuration.getProvider(), this.alias, this.pin);
        if (pk == null) {
            String msg = String.format("No private key found under alias '%s' for provider '%s'", this.alias, this.configuration.getProvider().getName());
            log.trace("{}", (Object)msg);
            throw new KeyException(msg);
        }
        super.setPrivateKey(pk);
        log.trace("Private key under alias '{}' for provider '{}' was reloaded", (Object)this.alias, (Object)this.configuration.getProvider().getName());
    }

    @Override
    protected String getDefaultName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.configuration != null ? this.configuration.getProvider().getName() : "Pkcs11Credential").append("-").append(this.alias != null ? this.alias : UUID.randomUUID().toString());
        return sb.toString();
    }
}

