/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.converters;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;

public class PropertyToX509CertificateConverter
implements Converter<String, X509Certificate>,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public X509Certificate convert(String source) {
        X509Certificate x509Certificate;
        block8: {
            Resource resource = this.applicationContext.getResource(source);
            InputStream is = resource.getInputStream();
            try {
                x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    throw new IllegalArgumentException(String.format("Failed to convert %s to a X509Certificate", source));
                }
            }
            is.close();
        }
        return x509Certificate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

