/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.factory;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyStoreFactoryBean
extends AbstractFactoryBean<KeyStore> {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreFactoryBean.class);
    private Resource resource;
    private char[] password;
    private String type;
    private String provider;
    private String pkcs11Configuration;

    public KeyStoreFactoryBean() {
    }

    public KeyStoreFactoryBean(Resource resource, char[] password) {
        this(resource, password, KeyStore.getDefaultType());
    }

    public KeyStoreFactoryBean(Resource resource, char[] password, String type) {
        this.resource = resource;
        this.password = password != null ? Arrays.copyOf(password, password.length) : null;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore createInstance() throws Exception {
        try {
            KeyStore keystore;
            if (this.type == null) {
                this.type = KeyStore.getDefaultType();
                log.debug("KeyStore type not given, defaulting to '{}'", (Object)this.type);
            }
            if ("PKCS11".equalsIgnoreCase(this.type)) {
                Provider securityProvider;
                if (this.provider == null) {
                    log.debug("PKCS#11 configuration is assigned - assuming SunPKCS11 provider");
                    this.provider = "SunPKCS11";
                }
                if ((securityProvider = Security.getProvider(this.provider)) == null) {
                    throw new NoSuchProviderException(String.format("Provider '%s' does not exist", this.provider));
                }
                if (!securityProvider.isConfigured()) {
                    if (this.pkcs11Configuration == null) {
                        throw new IllegalArgumentException("Missing pkcs11Configuration");
                    }
                    log.debug("Configuring security provider '{}' using '{}'", (Object)this.provider, (Object)this.pkcs11Configuration);
                    securityProvider = securityProvider.configure(this.pkcs11Configuration);
                    Security.addProvider(securityProvider);
                    this.provider = securityProvider.getName();
                    log.debug("After configuration of provider, the '{}' provider name will be used", (Object)this.provider);
                } else {
                    if (this.pkcs11Configuration != null) {
                        throw new IllegalArgumentException(String.format("Security provider '%s' has already been configured - pkcs11Configuration should be null", this.provider));
                    }
                    log.debug("Security provider '{}' has been statically configured", (Object)this.provider);
                }
            }
            KeyStore keyStore = keystore = this.provider != null ? KeyStore.getInstance(this.type, this.provider) : KeyStore.getInstance(this.type);
            if (this.resource != null) {
                try (InputStream is = this.resource.getInputStream();){
                    keystore.load(is, this.password);
                }
            } else {
                keystore.load(null, this.password);
            }
            KeyStore keyStore2 = keystore;
            return keyStore2;
        }
        finally {
            if (this.isSingleton()) {
                Arrays.fill(this.password, '\u0000');
            }
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = Optional.ofNullable(password).map(p -> Arrays.copyOf(p, ((char[])p).length)).orElse(null);
    }

    public String getType() {
        return this.type != null ? this.type : KeyStore.getDefaultType();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPkcs11Configuration() {
        return this.pkcs11Configuration;
    }

    public void setPkcs11Configuration(String pkcs11Configuration) {
        this.pkcs11Configuration = pkcs11Configuration;
    }

    public Class<?> getObjectType() {
        return KeyStore.class;
    }

    public void afterPropertiesSet() throws Exception {
        if (!"PKCS11".equalsIgnoreCase(this.type)) {
            Assert.notNull((Object)this.resource, (String)"The property 'resource' must be assigned");
        }
        Assert.notNull((Object)this.password, (String)"The property 'password' must be assigned");
        if (!StringUtils.hasText((String)this.type)) {
            this.type = KeyStore.getDefaultType();
            log.debug("Property 'type' was not assigned - defaulting to '{}'", (Object)this.type);
        }
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }
}

