/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.factory;

import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Optional;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import se.swedenconnect.security.credential.AbstractPkiCredential;
import se.swedenconnect.security.credential.BasicCredential;
import se.swedenconnect.security.credential.KeyStoreCredential;
import se.swedenconnect.security.credential.Pkcs11Credential;
import se.swedenconnect.security.credential.PkiCredential;

public class PkiCredentialFactoryBean
extends AbstractFactoryBean<PkiCredential> {
    private static final Logger log = LoggerFactory.getLogger(PkiCredentialFactoryBean.class);
    private String name;
    private Resource certificate;
    private Resource privateKey;
    private Resource resource;
    private char[] password;
    private String type;
    private String provider;
    private String pkcs11Configuration;
    private String alias;
    private char[] keyPassword;

    protected PkiCredential createInstance() throws Exception {
        AbstractPkiCredential credential = null;
        if (this.certificate != null && this.privateKey != null) {
            PrivateKey _privateKey = null;
            try (InputStream is = this.privateKey.getInputStream();){
                _privateKey = KeySupport.decodePrivateKey((InputStream)is, null);
            }
            credential = new BasicCredential(this.certificate, _privateKey);
        } else if (StringUtils.hasText((String)this.pkcs11Configuration) && StringUtils.hasText((String)this.alias) && this.keyPassword != null && (!StringUtils.hasText((String)this.type) || "PKCS11".equalsIgnoreCase(this.type))) {
            Pkcs11Credential p11Cred = new Pkcs11Credential();
            p11Cred.setConfigurationFile(this.pkcs11Configuration);
            p11Cred.setAlias(this.alias);
            p11Cred.setPin(this.keyPassword);
            if (this.certificate != null) {
                p11Cred.setCertificate(this.certificate);
            }
            credential = p11Cred;
        } else if (this.resource != null && this.password != null && this.alias != null) {
            KeyStoreCredential ksCred = new KeyStoreCredential();
            ksCred.setResource(this.resource);
            ksCred.setPassword(this.password);
            ksCred.setAlias(this.alias);
            ksCred.setType(this.type);
            if (StringUtils.hasText((String)this.provider)) {
                ksCred.setProvider(this.provider);
            }
            ksCred.setKeyPassword(this.keyPassword);
            credential = ksCred;
        }
        if (credential == null) {
            throw new SecurityException("PkiCredentialFactoryBean was not correctly configured");
        }
        if (StringUtils.hasText((String)this.name)) {
            credential.setName(this.name);
        }
        credential.afterPropertiesSet();
        return credential;
    }

    public Class<?> getObjectType() {
        return PkiCredential.class;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCertificate(Resource certificate) {
        this.certificate = certificate;
    }

    public void setPrivateKey(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setPassword(char[] password) {
        this.password = Optional.ofNullable(password).map(p -> Arrays.copyOf(p, ((char[])p).length)).orElse(null);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setPkcs11Configuration(String pkcs11Configuration) {
        this.pkcs11Configuration = pkcs11Configuration;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = Optional.ofNullable(keyPassword).map(p -> Arrays.copyOf(p, ((char[])p).length)).orElse(null);
    }

    public void setPin(char[] pin) {
        this.setKeyPassword(pin);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.certificate != null && this.privateKey != null) {
            log.debug("A BasicCredential will be created");
        } else if (StringUtils.hasText((String)this.pkcs11Configuration) && StringUtils.hasText((String)this.alias) && this.keyPassword != null && (!StringUtils.hasText((String)this.type) || "PKCS11".equalsIgnoreCase(this.type))) {
            log.debug("A Pkcs11Credential will be created");
        } else if (this.resource != null && this.password != null && this.alias != null) {
            log.debug("A KeyStoreCredential will be created");
        } else {
            throw new IllegalArgumentException("Missing credential configuration - cannot create");
        }
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
        if (this.keyPassword != null) {
            Arrays.fill(this.keyPassword, '\u0000');
        }
    }
}

