/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.factory;

import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class X509CertificateFactoryBean
extends AbstractFactoryBean<X509Certificate> {
    private Resource resource;

    public X509CertificateFactoryBean() {
    }

    public X509CertificateFactoryBean(Resource resource) {
        this.resource = resource;
    }

    protected X509Certificate createInstance() throws Exception {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(this.resource.getInputStream());
    }

    public Class<?> getObjectType() {
        return X509Certificate.class;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Property 'resource' has not been assigned");
        super.afterPropertiesSet();
    }
}

