/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.monitoring;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import se.swedenconnect.security.credential.ReloadablePkiCredential;
import se.swedenconnect.security.credential.monitoring.CredentialMonitorBean;

public class DefaultCredentialMonitorBean
implements CredentialMonitorBean,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultCredentialMonitorBean.class);
    private List<ReloadablePkiCredential> credentials;
    private List<ReloadablePkiCredential> additionalForReload;
    private BiFunction<ReloadablePkiCredential, Exception, Boolean> failureCallback;
    private Consumer<ReloadablePkiCredential> reloadSuccessCallback;
    private BiConsumer<ReloadablePkiCredential, Exception> reloadFailureCallback;

    public DefaultCredentialMonitorBean() {
    }

    public DefaultCredentialMonitorBean(ReloadablePkiCredential credential) {
        this(credential, null);
    }

    public DefaultCredentialMonitorBean(ReloadablePkiCredential credential, List<ReloadablePkiCredential> additionalForReload) {
        if (credential != null) {
            this.credentials = Arrays.asList(credential);
        }
        if (additionalForReload != null && !additionalForReload.isEmpty()) {
            this.additionalForReload = additionalForReload;
        }
    }

    public DefaultCredentialMonitorBean(List<ReloadablePkiCredential> credentials) {
        this.credentials = credentials;
    }

    @Override
    public void test() {
        boolean additionalReloaded = false;
        for (ReloadablePkiCredential cred : this.credentials) {
            Supplier<Exception> testFunction = cred.getTestFunction();
            if (testFunction == null) {
                log.trace("Credential '{}' can not be tested - it has no test function installed", (Object)cred.getName());
                continue;
            }
            log.trace("Testing credential '{}' ...", (Object)cred.getName());
            Exception testResult = testFunction.get();
            if (testResult == null) {
                log.trace("Test of credential '{}' was successful", (Object)cred.getName());
                continue;
            }
            Boolean reload = true;
            if (this.failureCallback != null) {
                log.debug("Test of credential '{}' failed - {}", new Object[]{cred.getName(), testResult.getMessage(), testResult});
                reload = this.failureCallback.apply(cred, testResult);
                if (reload == null) {
                    log.warn("Failure callback returned null - assuming FALSE");
                    reload = false;
                }
                if (!reload.booleanValue()) {
                    log.debug("Callback invoked and returned false, meaning no reloading of credential '{}' will occur", (Object)cred.getName());
                }
            } else {
                log.error("Test of credential '{}' failed - {}", (Object)cred.getName(), (Object)testResult.getMessage());
                log.debug("Credential failure details", (Throwable)testResult);
            }
            if (!reload.booleanValue()) continue;
            this.reload(cred);
            if (additionalReloaded) continue;
            if (this.additionalForReload != null) {
                this.additionalForReload.forEach(c -> this.reload((ReloadablePkiCredential)c));
            }
            additionalReloaded = true;
        }
    }

    protected void reload(ReloadablePkiCredential credential) {
        try {
            log.debug("Reloading credential '{}' ...", (Object)credential.getName());
            credential.reload();
            log.debug("Credential '{}' successfully reloaded, will test again ...", (Object)credential.getName());
            Supplier<Exception> testFunction = credential.getTestFunction();
            Exception testResult = null;
            if (testFunction == null) {
                log.trace("Credential '{}' can not be tested - it has no test function installed", (Object)credential.getName());
            } else {
                testResult = testFunction.get();
            }
            if (testResult == null) {
                log.debug("Credential '{}' was reloaded and is now functional again ...", (Object)credential.getName());
                if (this.reloadSuccessCallback != null) {
                    this.reloadSuccessCallback.accept(credential);
                }
            } else if (this.reloadFailureCallback != null) {
                log.debug("Test of credential '{}' after it was reloaded failed - {}", new Object[]{credential.getName(), testResult.getMessage(), testResult});
                this.reloadFailureCallback.accept(credential, testResult);
            } else {
                log.error("Test of credential '{}' after it was reloaded failed - {}", (Object)credential.getName(), (Object)testResult.getMessage());
                log.debug("Credential failure details", (Throwable)testResult);
            }
        }
        catch (Exception e) {
            if (this.reloadFailureCallback != null) {
                log.debug("Reloading of credential '{}' failed - {}", new Object[]{credential.getName(), e.getMessage(), e});
                this.reloadFailureCallback.accept(credential, e);
            }
            log.error("Reloading of credential '{}' failed - {}", (Object)credential.getName(), (Object)e.getMessage());
            log.debug("Credential failure details", (Throwable)e);
        }
    }

    public void setCredential(ReloadablePkiCredential credential) {
        this.credentials = Optional.ofNullable(credential).map(c -> Arrays.asList(c)).orElse(null);
    }

    public void setCredentials(List<ReloadablePkiCredential> credentials) {
        this.credentials = credentials;
    }

    public void setAdditionalForReload(List<ReloadablePkiCredential> additionalForReload) {
        this.additionalForReload = additionalForReload;
    }

    public void setFailureCallback(BiFunction<ReloadablePkiCredential, Exception, Boolean> failureCallback) {
        this.failureCallback = failureCallback;
    }

    public void setReloadSuccessCallback(Consumer<ReloadablePkiCredential> reloadSuccessCallback) {
        this.reloadSuccessCallback = reloadSuccessCallback;
    }

    public void setReloadFailureCallback(BiConsumer<ReloadablePkiCredential, Exception> reloadFailureCallback) {
        this.reloadFailureCallback = reloadFailureCallback;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.credentials, (String)"No credentials to monitor supplied");
        for (ReloadablePkiCredential c : this.credentials) {
            if (c.getTestFunction() != null) continue;
            log.warn("Configured credential '{}' has no test function associated - no montoring will be performed", (Object)c.getName());
        }
    }
}

