/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.monitoring;

import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.credential.PkiCredential;
import se.swedenconnect.security.credential.ReloadablePkiCredential;

public class DefaultCredentialTestFunction
implements Function<ReloadablePkiCredential, Exception> {
    private static final Logger log = LoggerFactory.getLogger(DefaultCredentialTestFunction.class);
    private String provider;
    private String rsaSignatureAlgorithm = "SHA256withRSA";
    private String dsaSignatureAlgorithm = "SHA256withDSA";
    private String ecSignatureAlgorithm = "SHA256withECDSA";
    private static final byte[] TEST_DATA = "testdata".getBytes();

    @Override
    public Exception apply(ReloadablePkiCredential credential) {
        try {
            PrivateKey pk = credential.getPrivateKey();
            if (pk == null) {
                return new KeyException(String.format("No private key available for credential '%s'", credential.getName()));
            }
            String algorithm = null;
            if ("RSA".equals(pk.getAlgorithm())) {
                algorithm = this.rsaSignatureAlgorithm;
            } else if ("DSA".equals(pk.getAlgorithm())) {
                algorithm = this.dsaSignatureAlgorithm;
            } else if ("EC".equals(pk.getAlgorithm())) {
                algorithm = this.ecSignatureAlgorithm;
            } else {
                String msg = String.format("Unknown private key algorithm (%s) - Cannot perform test of credential '%s'", pk.getAlgorithm(), credential.getName());
                log.warn("{}", (Object)msg);
                return new NoSuchAlgorithmException(msg);
            }
            Signature signature = this.provider != null ? Signature.getInstance(algorithm, this.provider) : Signature.getInstance(algorithm);
            signature.initSign(pk);
            signature.update(TEST_DATA);
            signature.sign();
        }
        catch (Exception e) {
            log.debug("Test of credential '{}' failed - {}", (Object)Optional.ofNullable(credential).map(PkiCredential::getName).orElse("null"), (Object)e.getMessage());
            return e;
        }
        log.trace("Test of credential '{}' was successful", (Object)credential.getName());
        return null;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setRsaSignatureAlgorithm(String rsaSignatureAlgorithm) {
        if (rsaSignatureAlgorithm != null) {
            this.rsaSignatureAlgorithm = rsaSignatureAlgorithm;
        }
    }

    public void setDsaSignatureAlgorithm(String dsaSignatureAlgorithm) {
        if (dsaSignatureAlgorithm != null) {
            this.dsaSignatureAlgorithm = dsaSignatureAlgorithm;
        }
    }

    public void setEcSignatureAlgorithm(String ecSignatureAlgorithm) {
        if (ecSignatureAlgorithm != null) {
            this.ecSignatureAlgorithm = ecSignatureAlgorithm;
        }
    }
}

