/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.opensaml;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.security.x509.BasicX509Credential;
import se.swedenconnect.security.credential.PkiCredential;

public class OpenSamlCredential
extends BasicX509Credential {
    private PkiCredential credential = null;
    private boolean chainAssigned = false;

    public OpenSamlCredential() {
        super(null);
    }

    public OpenSamlCredential(X509Certificate entityCertificate, PrivateKey privateKey) {
        super(entityCertificate, privateKey);
    }

    public OpenSamlCredential(PkiCredential credential) {
        super(null);
        this.credential = (PkiCredential)Constraint.isNotNull((Object)credential, (String)"Credential cannot be null");
    }

    public PublicKey getPublicKey() {
        return this.credential != null ? this.credential.getPublicKey() : super.getPublicKey();
    }

    public PrivateKey getPrivateKey() {
        return this.credential != null ? this.credential.getPrivateKey() : super.getPrivateKey();
    }

    public void setPrivateKey(PrivateKey privateKey) {
        Constraint.isNull((Object)this.credential, (String)"Private key may not be installed when object is created using a PkiCredential");
        super.setPrivateKey(privateKey);
    }

    public X509Certificate getEntityCertificate() {
        return this.credential != null ? this.credential.getCertificate() : super.getEntityCertificate();
    }

    public void setEntityCertificate(X509Certificate entityCertificate) {
        Constraint.isNull((Object)this.credential, (String)"Entity certificate may not be installed when object is created using a PkiCredential");
        if (entityCertificate != null) {
            super.setEntityCertificate(entityCertificate);
        }
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        if (this.chainAssigned) {
            return super.getEntityCertificateChain();
        }
        LazySet constructedChain = new LazySet();
        constructedChain.add((Object)this.getEntityCertificate());
        return constructedChain;
    }

    public void setEntityCertificateChain(Collection<X509Certificate> certificateChain) {
        super.setEntityCertificateChain(certificateChain);
        this.chainAssigned = true;
    }

    public void setCredential(PkiCredential credential) {
        Constraint.isNull((Object)super.getEntityCertificate(), (String)"Credential can not be assigned since certificate has already been assigned");
        Constraint.isNull((Object)super.getPrivateKey(), (String)"Credential can not be assigned since private key has already been assigned");
        this.credential = (PkiCredential)Constraint.isNotNull((Object)credential, (String)"Credential cannot be null");
    }
}

