/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.pkcs11conf;

import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import se.swedenconnect.security.credential.pkcs11conf.Pkcs11Configuration;
import se.swedenconnect.security.credential.pkcs11conf.Pkcs11ConfigurationException;

public abstract class AbstractPkcs11Configuration
implements Pkcs11Configuration,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractPkcs11Configuration.class);
    private String configurationFile;
    private String library;
    private String name;
    private String slot;
    private Integer slotListIndex;

    public AbstractPkcs11Configuration() {
    }

    public AbstractPkcs11Configuration(String configurationFile) throws Pkcs11ConfigurationException {
        this.configurationFile = AbstractPkcs11Configuration.validateConfigurationFile(configurationFile);
    }

    public AbstractPkcs11Configuration(String library, String name, String slot, Integer slotListIndex) {
        this.library = Optional.ofNullable(library).map(String::trim).orElse(null);
        this.name = Optional.ofNullable(name).map(String::trim).orElse(null);
        this.slot = Optional.ofNullable(slot).map(String::trim).orElse(null);
        if (slotListIndex != null && slotListIndex < 0) {
            throw new IllegalArgumentException("slotListIndex must be 0 or greater");
        }
        this.slotListIndex = slotListIndex;
    }

    public void afterPropertiesSet() throws Pkcs11ConfigurationException {
        if (this.configurationFile == null) {
            if (!StringUtils.hasText((String)this.name)) {
                throw new Pkcs11ConfigurationException("Invalid configuration - 'configurationFile' or 'name' must be set");
            }
            if (!StringUtils.hasText((String)this.library)) {
                throw new Pkcs11ConfigurationException("Invalid configuration - 'configurationFile' or 'library' must be set");
            }
        }
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        String string = this.configurationFile = configurationFile != null ? AbstractPkcs11Configuration.validateConfigurationFile(configurationFile) : null;
        if (this.configurationFile != null) {
            if (StringUtils.hasText((String)this.name)) {
                log.warn("Invalid configuration - 'configurationFile' and 'name' is set - Value of assigned 'name' will be ignored");
                this.name = null;
            }
            if (StringUtils.hasText((String)this.library)) {
                log.warn("Invalid configuration - 'configurationFile' and 'library' is set - Value of assigned 'library' will be ignored");
                this.library = null;
            }
            if (StringUtils.hasText((String)this.slot)) {
                log.warn("Invalid configuration - 'configurationFile' and 'slot' is set - Value of assigned 'slot' will be ignored");
                this.slot = null;
            }
            if (this.slotListIndex != null) {
                log.warn("Invalid configuration - 'configurationFile' and 'slotListIndex' is set - Value of assigned 'slotListIndex' will be ignored");
                this.slotListIndex = null;
            }
        }
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String library) {
        if (this.configurationFile == null) {
            this.library = Optional.ofNullable(library).map(String::trim).orElse(null);
        } else {
            log.warn("Attempt to assign 'library' is ignored - configurationFile has already been assigned");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configurationFile == null) {
            this.name = Optional.ofNullable(name).map(String::trim).orElse(null);
        } else {
            log.warn("Attempt to assign 'name' is ignored - configurationFile has already been assigned");
        }
    }

    public String getSlot() {
        return this.slot;
    }

    public void setSlot(String slot) {
        if (this.configurationFile == null) {
            this.slot = Optional.ofNullable(slot).map(String::trim).orElse(null);
        } else {
            log.warn("Attempt to assign 'slot' is ignored - configurationFile has already been assigned");
        }
    }

    public Integer getSlotListIndex() {
        return this.slotListIndex;
    }

    public void setSlotListIndex(Integer slotListIndex) {
        if (this.configurationFile == null) {
            if (slotListIndex != null && slotListIndex < 0) {
                throw new IllegalArgumentException("slotListIndex must be 0 or greater");
            }
            this.slotListIndex = slotListIndex;
        } else {
            log.warn("Attempt to assign 'slotListIndex' is ignored - configurationFile has already been assigned");
        }
    }

    private static String validateConfigurationFile(String configurationFile) throws Pkcs11ConfigurationException {
        if (!StringUtils.hasText((String)configurationFile)) {
            throw new Pkcs11ConfigurationException("configurationFile must be set", new NullPointerException("configurationFile not set"));
        }
        File file = new File(configurationFile);
        if (!file.exists()) {
            throw new Pkcs11ConfigurationException(String.format("%s does not exist", configurationFile));
        }
        if (!file.isFile()) {
            throw new Pkcs11ConfigurationException(String.format("%s is not a file", configurationFile));
        }
        return file.getAbsolutePath();
    }

    public String toString() {
        if (this.configurationFile != null) {
            return this.configurationFile;
        }
        return String.format("library='%s', name='%s', slot='%s', slotListIndex='%d'", this.library, this.name, this.slot, this.slotListIndex);
    }
}

