/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.credential.pkcs11conf;

import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.credential.BasicCredential;
import se.swedenconnect.security.credential.PkiCredential;
import se.swedenconnect.security.credential.pkcs11conf.AbstractPkcs11Configuration;
import se.swedenconnect.security.credential.pkcs11conf.Pkcs11ConfigurationException;
import se.swedenconnect.security.credential.pkcs11conf.Pkcs11ObjectProvider;

public class DefaultPkcs11Configuration
extends AbstractPkcs11Configuration {
    private static final Logger log = LoggerFactory.getLogger(DefaultPkcs11Configuration.class);
    private Provider provider;
    private String baseProviderName = "SunPKCS11";

    public DefaultPkcs11Configuration() {
    }

    public DefaultPkcs11Configuration(String configurationFile) throws Pkcs11ConfigurationException {
        super(configurationFile);
    }

    public DefaultPkcs11Configuration(String library, String name, String slot, Integer slotListIndex) {
        super(library, name, slot, slotListIndex);
    }

    @Override
    public void afterPropertiesSet() throws Pkcs11ConfigurationException {
        Provider p = Security.getProvider(this.getBaseProviderName());
        if (p == null) {
            throw new Pkcs11ConfigurationException(String.format("Failed to get the %s provider", this.getBaseProviderName()));
        }
        if (p.isConfigured()) {
            if (this.getConfigurationFile() != null || this.getLibrary() != null || this.getName() != null || this.getSlot() != null || this.getSlotListIndex() != null) {
                throw new Pkcs11ConfigurationException("Provider is statically configured - DefaultPkcs11Configuration must not have any configuration");
            }
            this.provider = p;
        } else {
            super.afterPropertiesSet();
        }
    }

    @Override
    public synchronized Provider getProvider() throws Pkcs11ConfigurationException {
        if (this.provider != null) {
            return this.provider;
        }
        Provider p = Security.getProvider(this.getBaseProviderName());
        if (p == null) {
            throw new Pkcs11ConfigurationException(String.format("Failed to get the %s provider", this.getBaseProviderName()));
        }
        if (!p.isConfigured()) {
            String configData = this.getConfigurationData();
            log.debug("Configuring {} provider with the following configuration data: {}", (Object)this.getBaseProviderName(), (Object)configData);
            try {
                p = p.configure(configData);
            }
            catch (InvalidParameterException e) {
                throw new Pkcs11ConfigurationException(String.format("Failed to configure %s provider", this.getBaseProviderName()), e);
            }
            log.debug("{} provider successfully configured - Provider name: {}", (Object)this.getBaseProviderName(), (Object)p.getName());
            int result = Security.addProvider(p);
            if (result == -1) {
                log.warn("A provider with the name '{}' has already been installed", (Object)p.getName());
            }
        } else {
            log.debug("The {} provider has already been configured ...", (Object)this.getBaseProviderName());
        }
        this.provider = p;
        return this.provider;
    }

    @Override
    public Pkcs11ObjectProvider<PrivateKey> getPrivateKeyProvider() {
        return (provider, alias, pin) -> {
            try {
                log.debug("Creating a PKCS11 KeyStore using provider '{}' ...", (Object)provider.getName());
                KeyStore keyStore = KeyStore.getInstance("PKCS11", provider.getName());
                log.debug("Loading KeyStore using supplied PIN ...");
                keyStore.load(null, pin);
                log.debug("Getting private key from entry '{}' ...", (Object)alias);
                PrivateKey pk = (PrivateKey)keyStore.getKey(alias, pin);
                if (pk != null) {
                    log.debug("Private key was successfully obtained from device at alias '{}' using provider '{}'", (Object)alias, (Object)provider.getName());
                } else {
                    log.debug("No private key was found on device at alias '{}' using provider '{}'", (Object)alias, (Object)provider.getName());
                }
                return pk;
            }
            catch (Exception e) {
                throw new SecurityException(String.format("Failed to load private key from provider '%s' - {}", provider.getName(), e.getMessage()), e);
            }
        };
    }

    @Override
    public Pkcs11ObjectProvider<PkiCredential> getCredentialProvider() {
        return (provider, alias, pin) -> {
            try {
                log.debug("Creating a PKCS11 KeyStore using provider '{}' ...", (Object)provider.getName());
                KeyStore keyStore = KeyStore.getInstance("PKCS11", provider.getName());
                log.debug("Loading KeyStore using supplied PIN ...");
                keyStore.load(null, pin);
                log.debug("Getting private key from entry '{}' ...", (Object)alias);
                PrivateKey pk = (PrivateKey)keyStore.getKey(alias, pin);
                if (pk == null) {
                    log.debug("No private key was found on device at alias '{}' using provider '{}'", (Object)alias, (Object)provider.getName());
                    return null;
                }
                log.debug("Private key was successfully obtained from device at alias '{}' using provider '{}'", (Object)alias, (Object)provider.getName());
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                if (cert != null) {
                    log.debug("Certificate was successfully obtained from device at alias '{}' using provider '{}'", (Object)alias, (Object)provider.getName());
                } else {
                    log.debug("No certificate was found on device at alias '{}' using provider '{}'", (Object)alias, (Object)provider.getName());
                }
                return new BasicCredential(cert, pk);
            }
            catch (Exception e) {
                throw new SecurityException(String.format("Failed to load private key and certificate from provider '%s' - {}", provider.getName(), e.getMessage()), e);
            }
        };
    }

    protected String getConfigurationData() throws Pkcs11ConfigurationException {
        try {
            this.afterPropertiesSet();
            if (this.getConfigurationFile() != null) {
                return this.getConfigurationFile();
            }
            StringBuffer sb = new StringBuffer("--");
            sb.append("library = ").append(this.getLibrary()).append(System.lineSeparator());
            sb.append("name = ").append(this.getName()).append(System.lineSeparator());
            if (this.getSlot() != null) {
                sb.append("slot = ").append(this.getSlot()).append(System.lineSeparator());
            }
            if (this.getSlotListIndex() != null) {
                sb.append("slotListIndex = ").append(this.getSlotListIndex()).append(System.lineSeparator());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new Pkcs11ConfigurationException(e.getMessage(), e);
        }
    }

    public void setBaseProviderName(String baseProviderName) {
        this.baseProviderName = baseProviderName;
    }

    protected String getBaseProviderName() {
        return this.baseProviderName != null ? this.baseProviderName : "SunPKCS11";
    }
}

