/*
 * Decompiled with CFR 0.152.
 */
package se.tada.util.sax;

import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;
import se.tada.util.sax.MissingRequiredAttributeException;

public abstract class AbstractHandler
extends DefaultHandler {
    protected abstract Locator getDocumentLocator();

    protected abstract String getTAG();

    public static final String getOptionalStringValue(Attributes attrs, String qName) {
        String value = attrs.getValue(qName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public static final String getOptionalStringValue(Attributes attrs, String qName, String defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getOptionalBooleanValue(Attributes attrs, String qName, boolean defaultValue) throws MissingRequiredAttributeException {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null) {
            return defaultValue;
        }
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }

    public static final double getOptionalDoubleValue(Attributes attrs, String qName, double defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public static final long getOptionalLongValue(Attributes attrs, String qName, long defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public static final int getOptionalIntValue(Attributes attrs, String qName, int defaultValue) {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected String getStringValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        String value = AbstractHandler.getOptionalStringValue(attrs, qName);
        if (value == null) {
            throw new MissingRequiredAttributeException(this.getTAG(), qName, this.getDocumentLocator());
        }
        return value;
    }

    protected boolean getBooleanValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        String value = this.getStringValue(attrs, qName);
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }

    protected int getIntValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        return Integer.parseInt(this.getStringValue(attrs, qName));
    }

    protected long getLongValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        return Long.parseLong(this.getStringValue(attrs, qName));
    }

    protected double getDoubleValue(Attributes attrs, String qName) throws MissingRequiredAttributeException {
        return Double.parseDouble(this.getStringValue(attrs, qName));
    }
}

