/*
 * Decompiled with CFR 0.152.
 */
package se.tada.util.sax;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import se.tada.util.sax.AbstractHandler;
import se.tada.util.sax.TopHandler;
import se.tada.util.sax.UnrecognizedElementException;

public abstract class ChildHandler
extends AbstractHandler {
    private static final HandlerKey s_keyTemplate = new HandlerKey();
    private TopHandler m_topHandler;

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.length() == 0) {
            localName = qName;
        }
        if (uri.length() == 0) {
            uri = null;
        }
        this.pushHandler(this.getHandler(uri, localName, attrs), attrs);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.popHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChildHandler getHandler(String uri, String localName, Attributes attrs) throws SAXException {
        String typeName = attrs.getValue("http://www.w3.org/2001/XMLSchema", "type");
        HashMap handlerCache = this.getTopHandler().getHandlerCache();
        HandlerKey handlerKey = s_keyTemplate;
        synchronized (handlerKey) {
            s_keyTemplate.init(uri, localName, typeName);
            ChildHandler ch = (ChildHandler)handlerCache.get(s_keyTemplate);
            if (ch == null) {
                ch = this.createHandler(uri, localName, typeName);
                handlerCache.put(s_keyTemplate.clone(), ch);
                ch.setTopHandler(this.m_topHandler);
            }
            return ch;
        }
    }

    protected ChildHandler createHandler(String uri, String localName, String typeName) throws SAXException {
        throw new UnrecognizedElementException(this.getTAG(), localName, this.getDocumentLocator());
    }

    protected void handleAttributes(Attributes attributes) throws SAXException {
    }

    protected final Locator getDocumentLocator() {
        return this.m_topHandler.getDocumentLocator();
    }

    protected final AbstractHandler getParentHandler() {
        return this.m_topHandler.getParentHandler(this);
    }

    protected final TopHandler getTopHandler() {
        return this.m_topHandler;
    }

    protected final void popHandler() {
        this.m_topHandler.popHandler();
    }

    protected final void pushHandler(ChildHandler handler, Attributes attrs) throws SAXException {
        this.m_topHandler.pushHandler(handler, attrs);
    }

    protected String getTAG() {
        try {
            Field idField = this.getClass().getDeclaredField("TAG");
            int mods = idField.getModifiers();
            if (!idField.isAccessible()) {
                idField.setAccessible(true);
            }
            return Modifier.isStatic(mods) ? (String)idField.get(null) : null;
        }
        catch (NoSuchFieldException e) {
            return this.getClass() + "(lacks TAG field)";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    protected final void setTopHandler(TopHandler topHandler) {
        this.m_topHandler = topHandler;
    }

    private static class HandlerKey
    implements Cloneable {
        private String m_uri;
        private String m_localName;
        private String m_typeName;
        private int m_hash;

        HandlerKey() {
        }

        void init(String uri, String localName, String typeName) {
            int hash;
            int n = hash = localName == null ? 1 : 31 + localName.hashCode();
            if (uri != null) {
                hash = 31 * hash + uri.hashCode();
            }
            if (typeName != null) {
                hash = 31 * hash + typeName.hashCode();
            }
            this.m_uri = uri;
            this.m_localName = localName;
            this.m_typeName = typeName;
            this.m_hash = hash;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HandlerKey)) {
                return false;
            }
            HandlerKey other = (HandlerKey)obj;
            return HandlerKey.nullEquals(this.m_uri, other.m_uri) && HandlerKey.nullEquals(this.m_typeName, other.m_typeName) && HandlerKey.nullEquals(this.m_localName, other.m_localName);
        }

        public int hashCode() {
            return this.m_hash;
        }

        private static boolean nullEquals(String a, String b) {
            return a == null ? b == null : b != null && a.equals(b);
        }
    }
}

