/*
 * Decompiled with CFR 0.152.
 */
package se.tada.util.sax;

import org.xml.sax.SAXException;
import se.tada.util.sax.ChildHandler;

public abstract class StringElementHandler
extends ChildHandler {
    private char[] m_buffer = new char[64];
    private int m_length;

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.m_length == 0) {
            while (length > 0 && Character.isWhitespace(chars[start])) {
                ++start;
                --length;
            }
            if (length == 0) {
                return;
            }
            if (length > this.m_buffer.length) {
                this.m_buffer = new char[length];
            }
        } else if (this.m_length + length > this.m_buffer.length) {
            char[] newBuffer = new char[this.m_length + length];
            System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_length);
            this.m_buffer = newBuffer;
        }
        System.arraycopy(chars, start, this.m_buffer, this.m_length, length);
        this.m_length += length;
    }

    protected final char[] getBuffer() {
        return this.m_buffer;
    }

    protected final int getLengthAndReset() {
        int last = this.m_length - 1;
        while (last >= 0 && Character.isWhitespace(this.m_buffer[last])) {
            --last;
        }
        this.m_length = 0;
        return last + 1;
    }
}

