/*
 * Decompiled with CFR 0.152.
 */
package se.tada.util.sax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import se.tada.util.sax.AbstractHandler;
import se.tada.util.sax.ChildHandler;
import se.tada.util.sax.UnrecognizedElementException;
import se.tada.util.sax.Utils;

public abstract class TopHandler
extends AbstractHandler {
    private Locator m_documentLocator;
    private XMLReader m_reader;
    private final Stack m_handlerStack = new Stack();
    private final ArrayList m_handlerCache = new ArrayList();

    protected TopHandler(XMLReader parent) {
        this.m_reader = parent;
        parent.setContentHandler(this);
    }

    public final AbstractHandler getCurrentHandler() {
        return (AbstractHandler)this.m_reader.getContentHandler();
    }

    /*
     * Unable to fully structure code
     */
    public AbstractHandler getParentHandler(ChildHandler handler) {
        size = this.m_handlerStack.size();
        if (handler != this.getCurrentHandler()) ** GOTO lbl6
        return size == 0 ? this : (AbstractHandler)this.m_handlerStack.get(size - 1);
lbl-1000:
        // 1 sources

        {
            if (handler != this.m_handlerStack.get(size)) continue;
            return size == 0 ? this : (AbstractHandler)this.m_handlerStack.get(size - 1);
lbl6:
            // 2 sources

            ** while (--size >= 0)
        }
lbl7:
        // 1 sources

        return null;
    }

    public void pushFilter(XMLFilterImpl filter) {
        filter.setContentHandler(this.m_reader.getContentHandler());
        this.m_reader.setContentHandler(filter);
        filter.setParent(this.m_reader);
        this.m_reader = filter;
    }

    public void popFilter() {
        if (this.m_reader instanceof XMLFilterImpl) {
            XMLFilterImpl filter = (XMLFilterImpl)this.m_reader;
            this.m_reader = filter.getParent();
            this.m_reader.setContentHandler(filter.getContentHandler());
            filter.setParent(null);
            filter.setContentHandler(null);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        throw new UnrecognizedElementException("root", qName, this.getDocumentLocator());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.popHandler();
    }

    public String getEncoding() {
        return Utils.getEncoding(this.m_documentLocator);
    }

    public final void setDocumentLocator(Locator locator) {
        this.m_documentLocator = locator;
    }

    public final void setNamespaceAware(boolean flag) {
        try {
            this.m_reader.setFeature("http://xml.org/sax/features/namespaces", flag);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setEntityResolver(EntityResolver resolver) {
        this.m_reader.setEntityResolver(resolver);
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.m_reader.setErrorHandler(errorHandler);
    }

    protected final XMLReader getXMLReader() {
        return this.m_reader;
    }

    protected final Locator getDocumentLocator() {
        return this.m_documentLocator;
    }

    protected final void pushHandler(ChildHandler handler, Attributes attrs) throws SAXException {
        this.m_handlerStack.push(this.m_reader.getContentHandler());
        this.m_reader.setContentHandler(handler);
        handler.handleAttributes(attrs);
    }

    protected final void popHandler() {
        this.m_reader.setContentHandler((ContentHandler)this.m_handlerStack.pop());
    }

    protected final String getTAG() {
        return "root";
    }

    protected final void assignTopHandler(ChildHandler child) {
        child.setTopHandler(this);
    }

    protected final HashMap getHandlerCache() {
        int depth = this.m_handlerStack.size();
        int cacheSize = this.m_handlerCache.size();
        while (cacheSize <= depth) {
            this.m_handlerCache.add(new HashMap());
            ++cacheSize;
        }
        return (HashMap)this.m_handlerCache.get(depth);
    }

    protected class SAXParserWrapper
    implements ContentHandler {
        protected SAXParserWrapper() {
        }

        public void setDocumentLocator(Locator locator) {
            TopHandler.this.m_reader.getContentHandler().setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            TopHandler.this.m_reader.getContentHandler().startDocument();
        }

        public void endDocument() throws SAXException {
            TopHandler.this.m_reader.getContentHandler().endDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().endPrefixMapping(prefix);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().processingInstruction(target, data);
        }

        public void skippedEntity(String name) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().skippedEntity(name);
        }
    }
}

