/*
 * Decompiled with CFR 0.152.
 */
package se.tada.util.sax;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class Utils {
    private static final Class[] s_emptyArgTypes = new Class[0];
    private static final Object[] s_emptyArgs = new Object[0];
    private static final SAXParserFactory s_parserFactory = SAXParserFactory.newInstance();

    public static void addAttribute(AttributesImpl attrs, String name, String value) {
        attrs.addAttribute("", name, name, "CDATA", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLReader createXMLReader(boolean validating, boolean withNamespace) throws SAXException {
        try {
            SAXParserFactory sAXParserFactory = s_parserFactory;
            synchronized (sAXParserFactory) {
                s_parserFactory.setValidating(validating);
                s_parserFactory.setNamespaceAware(withNamespace);
                return s_parserFactory.newSAXParser().getXMLReader();
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static String getEncoding(Locator locator) {
        String enc = null;
        if (locator != null) {
            try {
                enc = (String)locator.getClass().getMethod("getEncoding", s_emptyArgTypes).invoke((Object)locator, s_emptyArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        return enc;
    }

    public static ContentHandler newSerializer(File file, OutputStream stream, String encoding, int indent) throws SAXException {
        TransformerHandler serializer;
        boolean java14 = System.getProperty("java.version").startsWith("1.4");
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            if (!tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new SAXException("The TransformerFactory is not a SAXTransformerFactory");
            }
            SAXTransformerFactory stf = (SAXTransformerFactory)tf;
            if (!java14 && indent >= 0) {
                stf.setAttribute("indent-number", Integer.toString(indent));
            }
            serializer = stf.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage());
        }
        Transformer t = serializer.getTransformer();
        t.setOutputProperty("method", "xml");
        if (encoding != null) {
            t.setOutputProperty("encoding", encoding);
        }
        if (indent >= 0) {
            t.setOutputProperty("indent", "yes");
            if (java14) {
                t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(indent));
            }
        }
        StreamResult out = new StreamResult();
        if (file != null) {
            out.setSystemId(file);
        }
        if (java14 || indent <= 0) {
            out.setOutputStream(stream);
        } else {
            try {
                if (encoding == null) {
                    encoding = t.getOutputProperty("encoding");
                }
                out.setWriter(new OutputStreamWriter(stream, encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new SAXException(e.getMessage());
            }
        }
        serializer.setResult(out);
        return serializer;
    }
}

