/*
 * Decompiled with CFR 0.152.
 */
package se.transmode.gradle.plugins.docker.client;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import se.transmode.gradle.plugins.docker.client.DockerClient;

public class JavaDockerClient
extends com.github.dockerjava.client.DockerClient
implements DockerClient {
    private static Logger log = Logging.getLogger(JavaDockerClient.class);

    JavaDockerClient() {
    }

    JavaDockerClient(String url) {
        super(url);
    }

    @Override
    public String buildImage(File buildDir, String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Image tag can not be null.");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"Image tag can not be empty.");
        ClientResponse response = (ClientResponse)this.buildImageCmd(buildDir).withTag(tag).exec();
        return JavaDockerClient.checkResponse(response);
    }

    @Override
    public String pushImage(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Image tag can not be null.");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"Image tag can not be empty.");
        ClientResponse response = (ClientResponse)this.pushImageCmd(tag).exec();
        return JavaDockerClient.checkResponse(response);
    }

    private static String checkResponse(ClientResponse response) {
        String msg = (String)response.getEntity(String.class);
        if (response.getStatusInfo() != ClientResponse.Status.OK) {
            throw new GradleException("Docker API error: Failed to build Image:\n" + msg);
        }
        return msg;
    }

    public static JavaDockerClient create(String url, String user, String password, String email) {
        JavaDockerClient client;
        if (StringUtils.isEmpty((String)url)) {
            log.info("Connecting to localhost");
            client = new JavaDockerClient("http://localhost:2375");
        } else {
            log.info("Connecting to {}", (Object)url);
            client = new JavaDockerClient(url);
        }
        if (StringUtils.isNotEmpty((String)user)) {
            client.setCredentials(user, password, email);
        }
        return client;
    }
}

