/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.populators.annotated.AnnotatedResultSetPopulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAnnotatedDAOFactory
implements AnnotatedDAOFactory {
    private final DataSource dataSource;
    private final HashMap<Class<?>, AnnotatedDAO<?>> daoMap = new HashMap();

    public SimpleAnnotatedDAOFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SimpleAnnotatedDAOFactory() {
        this.dataSource = null;
    }

    @Override
    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, this);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, AnnotatedResultSetPopulator<T> populator) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, populator, (List<QueryParameterPopulator<?>>)null, (List<BeanStringPopulator<?>>)null);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, AnnotatedResultSetPopulator<T> populator, QueryParameterPopulator<?> ... queryParameterPopulators) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, populator, queryParameterPopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, List<? extends QueryParameterPopulator<?>> queryParameterPopulators, List<? extends BeanStringPopulator<?>> typePopulators) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, queryParameterPopulators, typePopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public synchronized <T> AnnotatedDAO<T> getDAO(Class<T> beanClass, AnnotatedResultSetPopulator<T> populator, List<? extends QueryParameterPopulator<?>> queryParameterPopulators, List<? extends BeanStringPopulator<?>> typePopulators) {
        AnnotatedDAO<Object> dao = this.daoMap.get(beanClass);
        if (dao == null) {
            dao = new AnnotatedDAO<T>(this.dataSource, beanClass, (AnnotatedDAOFactory)this, populator, queryParameterPopulators, typePopulators);
            this.daoMap.put(beanClass, dao);
        }
        return dao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addDAO(Class<?> beanClass, AnnotatedDAO<?> daoInstance) {
        this.daoMap.put(beanClass, daoInstance);
    }
}

