/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tableExists(DataSource dataSource, String tableName) throws SQLException {
        ResultSet rs;
        Connection connection;
        block2: {
            connection = null;
            rs = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData meta = connection.getMetaData();
                rs = meta.getTables(null, null, tableName, null);
                if (!rs.next()) break block2;
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeConnection(connection);
            return true;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeConnection(connection);
        return false;
    }

    public static ArrayList<String> listAllTables(Connection connection) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet rs = null;
        try {
            DatabaseMetaData meta = connection.getMetaData();
            rs = meta.getTables(null, null, null, null);
            ArrayList<String> tableList = new ArrayList<String>();
            while (rs.next()) {
                tableList.add(rs.getString(3));
            }
            arrayList = tableList;
        }
        catch (Throwable throwable) {
            DBUtils.closeResultSet(rs);
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeConnection(connection);
        return arrayList;
    }

    public static DataSource getDataSource(String name) throws NamingException {
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup("java:/comp/env");
        return (DataSource)envContext.lookup(name);
    }

    public static boolean containsColumn(ResultSet rs, String columnName) {
        try {
            rs.findColumn(columnName);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static List<String> getTableColumns(Connection connection, String selectedTable) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet rs = null;
        try {
            DatabaseMetaData meta = connection.getMetaData();
            rs = meta.getColumns(null, null, selectedTable, null);
            ArrayList<String> columnNames = new ArrayList<String>();
            while (rs.next()) {
                columnNames.add(rs.getString(4));
            }
            arrayList = columnNames;
        }
        catch (Throwable throwable) {
            DBUtils.closeResultSet(rs);
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeConnection(connection);
        return arrayList;
    }

    public static int getTableColumnCount(DataSource dataSource, String selectedTable) throws SQLException {
        int n;
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData meta = connection.getMetaData();
            rs = meta.getColumns(null, null, selectedTable, null);
            rs.last();
            n = rs.getRow();
        }
        catch (Throwable throwable) {
            DBUtils.closeResultSet(rs);
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeConnection(connection);
        return n;
    }

    public static void closeConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closePreparedStatement(PreparedStatement pstmt) {
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

