/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.numbers;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtils {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\D*");

    public static boolean isLong(Double value) {
        Long longValue;
        Double doubleValue;
        return value != null && (doubleValue = Double.valueOf((longValue = Long.valueOf(value.longValue())).doubleValue())).equals(value);
    }

    public static boolean isInt(String value) {
        if (value != null) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isLong(String value) {
        if (value != null) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isFloat(String value) {
        if (value != null) {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDouble(String value) {
        if (value != null) {
            try {
                Double.parseDouble(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isNumber(String value) {
        return NumberUtils.isDouble(value) || NumberUtils.isLong(value);
    }

    public static Integer toInt(String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Integer> toInt(Collection<? extends Object> list, Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        if (list != null && type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            ArrayList<Integer> validIntegers = new ArrayList<Integer>();
            for (Object object : list) {
                Integer value = (Integer)field.get(object);
                if (value == null) continue;
                validIntegers.add(value);
            }
            return validIntegers;
        }
        return null;
    }

    public static ArrayList<Integer> toInt(Collection<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Integer> validIntegers = new ArrayList<Integer>();
        for (String value : values) {
            Integer intValue;
            if (value == null || (intValue = NumberUtils.toInt(value)) == null) continue;
            validIntegers.add(intValue);
        }
        if (validIntegers.isEmpty()) {
            return null;
        }
        return validIntegers;
    }

    public static ArrayList<Integer> toInt(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Integer> validIntegers = new ArrayList<Integer>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Integer intValue;
            String value = stringArray[n2];
            if (value != null && (intValue = NumberUtils.toInt(value)) != null) {
                validIntegers.add(intValue);
            }
            ++n2;
        }
        if (validIntegers.isEmpty()) {
            return null;
        }
        return validIntegers;
    }

    public static Long toLong(String value) {
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Float toFloat(String value) {
        if (value != null) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Double toDouble(String value) {
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Double> toDouble(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Double> validDoubles = new ArrayList<Double>();
        for (String value : values) {
            Double doubleValue;
            if (value == null || (doubleValue = NumberUtils.toDouble(value)) == null) continue;
            validDoubles.add(doubleValue);
        }
        if (validDoubles.isEmpty()) {
            return null;
        }
        return validDoubles;
    }

    public static List<Long> toLong(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Long> validLongs = new ArrayList<Long>();
        for (String value : values) {
            Long LongValue;
            if (value == null || (LongValue = NumberUtils.toLong(value)) == null) continue;
            validLongs.add(LongValue);
        }
        if (validLongs.isEmpty()) {
            return null;
        }
        return validLongs;
    }

    public static Long getNumbers(String revstring) {
        String result = NUMBER_PATTERN.matcher(revstring).replaceAll("");
        return NumberUtils.toLong(result);
    }

    public static String formatNumber(Number value, int minDecimals, int maxDecimals, boolean grouping, boolean dotDecimalSymbol) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMinimumFractionDigits(minDecimals);
        formatter.setMaximumFractionDigits(maxDecimals);
        if (dotDecimalSymbol) {
            formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        }
        formatter.setGroupingUsed(grouping);
        return formatter.format(value);
    }

    public static Byte toByte(String value) {
        if (value != null) {
            try {
                return Byte.parseByte(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

