/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.DiffHelper;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockableEntity;
import se.vandmo.dependencylock.maven.lang.Strings;

public class AbstractLockedEntries<EntityType extends LockableEntity<EntityType>> {
    final DiffHelper diffHelper;
    final Log log;

    AbstractLockedEntries(Log log) {
        this.diffHelper = new DiffHelper(log);
        this.log = log;
    }

    final List<String> diffVersion(AtomicReference<EntityType> lockedEntityRef, EntityType actualEntity, BiFunction<EntityType, String, EntityType> versionUpdater, Filters filters) {
        return this.diffHelper.diffVersion(lockedEntityRef, actualEntity, versionUpdater, filters);
    }

    List<String> findDiffs(AtomicReference<EntityType> lockedEntityRef, EntityType actualEntity, Filters filters) {
        ArrayList<String> wrongs = new ArrayList<String>();
        wrongs.addAll(this.diffIntegrity(lockedEntityRef, actualEntity, filters));
        return wrongs;
    }

    final String formatDifference(EntityType expected, EntityType actual, List<String> wrongs) {
        return String.format(Locale.ROOT, "Expected %s but found %s, wrong %s", expected, actual, Strings.joinNouns(wrongs));
    }

    final List<String> diffIntegrity(AtomicReference<EntityType> lockedEntityRef, EntityType actualEntity, Filters filters) {
        return this.diffHelper.diffIntegrity((LockableEntity)lockedEntityRef.get(), actualEntity, filters);
    }
}

