/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import java.util.Optional;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Checksum;
import se.vandmo.dependencylock.maven.Integrity;
import se.vandmo.dependencylock.maven.LockableEntity;
import se.vandmo.dependencylock.maven.MavenArtifact;
import se.vandmo.dependencylock.maven.lang.Strings;

public final class Artifact
extends LockableEntity<Artifact>
implements Comparable<Artifact> {
    public final ArtifactIdentifier identifier;
    public final String version;
    public final Integrity integrity;
    private org.apache.maven.artifact.Artifact mavenArtifact;

    public static ArtifactIdentifierBuilderStage builder() {
        return new ArtifactIdentifierBuilderStage();
    }

    private static String checkIntegrityArgument(String integrity) {
        Objects.requireNonNull(integrity);
        if (!Strings.startsWith(integrity, "sha512:") && !"ignored".equals(integrity)) {
            throw new IllegalArgumentException("Encountered unsupported checksum format, consider using a later version of this plugin");
        }
        return integrity;
    }

    public static Artifact from(org.apache.maven.artifact.Artifact artifact) {
        Integrity.Folder integrity = artifact.getFile().isDirectory() ? Integrity.Folder() : Integrity.Calculated(Checksum.calculateFor(artifact.getFile()));
        return new Artifact(ArtifactIdentifier.builder().groupId(artifact.getGroupId()).artifactId(artifact.getArtifactId()).classifier(Optional.ofNullable(artifact.getClassifier())).type(Optional.ofNullable(artifact.getType())).build(), artifact.getVersion(), integrity);
    }

    @Override
    public org.apache.maven.artifact.Artifact getMavenArtifact() {
        org.apache.maven.artifact.Artifact result = this.mavenArtifact;
        if (result == null) {
            this.mavenArtifact = result = MavenArtifact.unscoped(this);
        }
        return result;
    }

    private Artifact(ArtifactIdentifier identifier, String version, Integrity integrity) {
        this.identifier = Objects.requireNonNull(identifier);
        this.version = Objects.requireNonNull(version);
        this.integrity = integrity;
    }

    @Override
    public Artifact withVersion(String version) {
        return new Artifact(this.identifier, version, this.integrity);
    }

    @Override
    public Artifact withIntegrity(Integrity integrity) {
        return new Artifact(this.identifier, this.version, integrity);
    }

    @Override
    public String getIntegrityForLockFile() {
        return this.integrity.matching().Calculated(calculated -> calculated.checksum).Folder(folder -> {
            throw new IllegalStateException("Can not calculate dependencies for " + this.toString_withoutIntegrity() + " since it is a folder.");
        }).Ignored(ignored -> "ignored").get();
    }

    @Override
    public int compareTo(Artifact other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return this.toStringBuilder_withoutIntegrity().append('@').append(this.integrity.matching().Calculated(calculcated -> calculcated.checksum).Folder(folder -> "<Folder>").Ignored(ignored -> "<Ignored>").get()).toString();
    }

    @Override
    public String toString_withoutIntegrity() {
        return this.toStringBuilder_withoutIntegrity().toString();
    }

    StringBuilder toStringBuilder_withoutIntegrity() {
        return new StringBuilder().append(this.identifier.toString()).append(':').append(this.version);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.identifier);
        hash = 17 * hash + Objects.hashCode(this.version);
        hash = 17 * hash + Objects.hashCode(this.integrity);
        return hash;
    }

    @Override
    public ArtifactIdentifier getArtifactIdentifier() {
        return this.identifier;
    }

    @Override
    public Integrity getIntegrity() {
        return this.integrity;
    }

    @Override
    public String getArtifactKey() {
        return this.toString_withoutIntegrity();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        return Objects.equals(this.integrity, other.integrity);
    }

    public boolean equals_ignoreVersion(Artifact other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        return Objects.equals(this.integrity, other.integrity);
    }

    public static final class FinalBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;
        private final String version;
        private final Integrity integrity;

        private FinalBuilderStage(ArtifactIdentifier artifactIdentifier, String version, Integrity integrity) {
            this.artifactIdentifier = artifactIdentifier;
            this.version = version;
            this.integrity = integrity;
        }

        public Artifact build() {
            return new Artifact(this.artifactIdentifier, this.version, this.integrity);
        }
    }

    public static final class IntegrityBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;
        private final String version;

        private IntegrityBuilderStage(ArtifactIdentifier artifactIdentifier, String version) {
            this.artifactIdentifier = artifactIdentifier;
            this.version = version;
        }

        public FinalBuilderStage integrity(String integrity) {
            return new FinalBuilderStage(this.artifactIdentifier, this.version, Integrity.Calculated(Artifact.checkIntegrityArgument(integrity)));
        }

        public FinalBuilderStage integrity(Integrity integrity) {
            return new FinalBuilderStage(this.artifactIdentifier, this.version, Objects.requireNonNull(integrity));
        }
    }

    public static final class VersionBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;

        private VersionBuilderStage(ArtifactIdentifier artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public IntegrityBuilderStage version(String version) {
            return new IntegrityBuilderStage(this.artifactIdentifier, Objects.requireNonNull(version));
        }
    }

    public static final class ArtifactIdentifierBuilderStage {
        private ArtifactIdentifierBuilderStage() {
        }

        public VersionBuilderStage artifactIdentifier(ArtifactIdentifier artifactIdentifier) {
            return new VersionBuilderStage(Objects.requireNonNull(artifactIdentifier));
        }
    }
}

