/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Checksum;
import se.vandmo.dependencylock.maven.Integrity;
import se.vandmo.dependencylock.maven.LockableEntityWithArtifact;
import se.vandmo.dependencylock.maven.MavenArtifact;

public final class Dependency
extends LockableEntityWithArtifact<Dependency>
implements Comparable<Dependency> {
    public final String scope;
    public final boolean optional;

    public static ArtifactIdentifierBuilderStage builder() {
        return new ArtifactIdentifierBuilderStage();
    }

    public static ScopeBuilderStage forArtifact(Artifact artifact) {
        return new ScopeBuilderStage(Objects.requireNonNull(artifact));
    }

    public static Dependency from(org.apache.maven.artifact.Artifact artifact) {
        Integrity.Folder integrity = artifact.getFile().isDirectory() ? Integrity.Folder() : Integrity.Calculated(Checksum.calculateFor(artifact.getFile()));
        return new Dependency(Artifact.from(artifact).withIntegrity(integrity), artifact.getScope(), artifact.isOptional());
    }

    @Override
    org.apache.maven.artifact.Artifact toMavenArtifact() {
        return MavenArtifact.scoped(this.artifact, this.scope);
    }

    private Dependency(Artifact artifact, String scope, boolean optional) {
        super(artifact);
        this.scope = Objects.requireNonNull(scope);
        this.optional = optional;
    }

    @Override
    public Dependency withVersion(String version) {
        return new Dependency(this.artifact.withVersion(version), this.scope, this.optional);
    }

    @Override
    public Dependency withIntegrity(Integrity integrity) {
        return new Dependency(this.artifact.withIntegrity(integrity), this.scope, this.optional);
    }

    @Override
    public int compareTo(Dependency other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString_withoutIntegrity() {
        return this.toStringBuilder_withoutIntegrity().toString();
    }

    @Override
    protected StringBuilder toStringBuilder_withoutIntegrity() {
        return super.toStringBuilder_withoutIntegrity().append(':').append(this.scope).append(":optional=").append(this.optional);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.artifact);
        hash = 17 * hash + Objects.hashCode(this.scope);
        hash = 17 * hash + Objects.hashCode(this.optional);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (!Objects.equals(this.artifact, other.artifact)) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        return Objects.equals(this.optional, other.optional);
    }

    public boolean equals_ignoreVersion(Dependency other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!this.artifact.equals_ignoreVersion(other.artifact)) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        return Objects.equals(this.optional, other.optional);
    }

    public static final class FinalBuilderStage {
        private final Artifact artifact;
        private final String scope;
        private final boolean optional;

        private FinalBuilderStage(Artifact artifact, String scope, boolean optional) {
            this.artifact = artifact;
            this.scope = scope;
            this.optional = optional;
        }

        public Dependency build() {
            return new Dependency(this.artifact, this.scope, this.optional);
        }
    }

    public static final class IntegrityBuilderStage {
        private final Artifact.IntegrityBuilderStage artifactBuilder;

        private IntegrityBuilderStage(Artifact.IntegrityBuilderStage artifactBuilder) {
            this.artifactBuilder = artifactBuilder;
        }

        public ScopeBuilderStage integrity(String integrity) {
            return new ScopeBuilderStage(this.artifactBuilder.integrity(integrity).build());
        }
    }

    public static final class OptionalBuilderStage {
        private final Artifact artifact;
        private final String scope;

        private OptionalBuilderStage(Artifact artifact, String scope) {
            this.artifact = Objects.requireNonNull(artifact);
            this.scope = scope;
        }

        public Dependency build() {
            return this.optional(false).build();
        }

        public FinalBuilderStage optional(boolean optional) {
            return new FinalBuilderStage(this.artifact, this.scope, optional);
        }
    }

    public static final class ScopeBuilderStage {
        private final Artifact artifact;

        private ScopeBuilderStage(Artifact artifact) {
            this.artifact = Objects.requireNonNull(artifact);
        }

        public OptionalBuilderStage scope(String scope) {
            return new OptionalBuilderStage(this.artifact, Objects.requireNonNull(scope));
        }
    }

    public static final class VersionBuilderStage {
        private final Artifact.VersionBuilderStage artifactBuilder;

        private VersionBuilderStage(Artifact.VersionBuilderStage artifactBuilder) {
            this.artifactBuilder = Objects.requireNonNull(artifactBuilder);
        }

        public IntegrityBuilderStage version(String version) {
            return new IntegrityBuilderStage(this.artifactBuilder.version(version));
        }
    }

    public static final class ArtifactIdentifierBuilderStage {
        private ArtifactIdentifierBuilderStage() {
        }

        public VersionBuilderStage artifactIdentifier(ArtifactIdentifier artifactIdentifier) {
            return new VersionBuilderStage(Artifact.builder().artifactIdentifier(artifactIdentifier));
        }
    }
}

